package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSubCrowds invokes the pairecservice.ListSubCrowds API synchronously
func (client *Client) ListSubCrowds(request *ListSubCrowdsRequest) (response *ListSubCrowdsResponse, err error) {
	response = CreateListSubCrowdsResponse()
	err = client.DoAction(request, response)
	return
}

// ListSubCrowdsWithChan invokes the pairecservice.ListSubCrowds API asynchronously
func (client *Client) ListSubCrowdsWithChan(request *ListSubCrowdsRequest) (<-chan *ListSubCrowdsResponse, <-chan error) {
	responseChan := make(chan *ListSubCrowdsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSubCrowds(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSubCrowdsWithCallback invokes the pairecservice.ListSubCrowds API asynchronously
func (client *Client) ListSubCrowdsWithCallback(request *ListSubCrowdsRequest, callback func(response *ListSubCrowdsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSubCrowdsResponse
		var err error
		defer close(result)
		response, err = client.ListSubCrowds(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSubCrowdsRequest is the request struct for api ListSubCrowds
type ListSubCrowdsRequest struct {
	*requests.RoaRequest
	CrowdId    string `position:"Path" name:"CrowdId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// ListSubCrowdsResponse is the response struct for api ListSubCrowds
type ListSubCrowdsResponse struct {
	*responses.BaseResponse
	RequestId  string          `json:"RequestId" xml:"RequestId"`
	TotalCount int64           `json:"TotalCount" xml:"TotalCount"`
	SubCrowds  []SubCrowdsItem `json:"SubCrowds" xml:"SubCrowds"`
}

// CreateListSubCrowdsRequest creates a request to invoke ListSubCrowds API
func CreateListSubCrowdsRequest() (request *ListSubCrowdsRequest) {
	request = &ListSubCrowdsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "ListSubCrowds", "/api/v1/crowds/[CrowdId]/subcrowds", "", "")
	request.Method = requests.GET
	return
}

// CreateListSubCrowdsResponse creates a response to parse from ListSubCrowds response
func CreateListSubCrowdsResponse() (response *ListSubCrowdsResponse) {
	response = &ListSubCrowdsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
