package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateScene invokes the pairecservice.CreateScene API synchronously
func (client *Client) CreateScene(request *CreateSceneRequest) (response *CreateSceneResponse, err error) {
	response = CreateCreateSceneResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSceneWithChan invokes the pairecservice.CreateScene API asynchronously
func (client *Client) CreateSceneWithChan(request *CreateSceneRequest) (<-chan *CreateSceneResponse, <-chan error) {
	responseChan := make(chan *CreateSceneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateScene(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSceneWithCallback invokes the pairecservice.CreateScene API asynchronously
func (client *Client) CreateSceneWithCallback(request *CreateSceneRequest, callback func(response *CreateSceneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSceneResponse
		var err error
		defer close(result)
		response, err = client.CreateScene(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSceneRequest is the request struct for api CreateScene
type CreateSceneRequest struct {
	*requests.RoaRequest
	Body string `position:"Body" name:"body"`
}

// CreateSceneResponse is the response struct for api CreateScene
type CreateSceneResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	SceneId   string `json:"SceneId" xml:"SceneId"`
}

// CreateCreateSceneRequest creates a request to invoke CreateScene API
func CreateCreateSceneRequest() (request *CreateSceneRequest) {
	request = &CreateSceneRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "CreateScene", "/api/v1/scenes", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateSceneResponse creates a response to parse from CreateScene response
func CreateCreateSceneResponse() (response *CreateSceneResponse) {
	response = &CreateSceneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
