package paifeaturestore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFeatureViewOnlineFeatures invokes the paifeaturestore.ListFeatureViewOnlineFeatures API synchronously
func (client *Client) ListFeatureViewOnlineFeatures(request *ListFeatureViewOnlineFeaturesRequest) (response *ListFeatureViewOnlineFeaturesResponse, err error) {
	response = CreateListFeatureViewOnlineFeaturesResponse()
	err = client.DoAction(request, response)
	return
}

// ListFeatureViewOnlineFeaturesWithChan invokes the paifeaturestore.ListFeatureViewOnlineFeatures API asynchronously
func (client *Client) ListFeatureViewOnlineFeaturesWithChan(request *ListFeatureViewOnlineFeaturesRequest) (<-chan *ListFeatureViewOnlineFeaturesResponse, <-chan error) {
	responseChan := make(chan *ListFeatureViewOnlineFeaturesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFeatureViewOnlineFeatures(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFeatureViewOnlineFeaturesWithCallback invokes the paifeaturestore.ListFeatureViewOnlineFeatures API asynchronously
func (client *Client) ListFeatureViewOnlineFeaturesWithCallback(request *ListFeatureViewOnlineFeaturesRequest, callback func(response *ListFeatureViewOnlineFeaturesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFeatureViewOnlineFeaturesResponse
		var err error
		defer close(result)
		response, err = client.ListFeatureViewOnlineFeatures(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFeatureViewOnlineFeaturesRequest is the request struct for api ListFeatureViewOnlineFeatures
type ListFeatureViewOnlineFeaturesRequest struct {
	*requests.RoaRequest
	InstanceId    string `position:"Path" name:"InstanceId"`
	JoinIds       string `position:"Query" name:"JoinIds"`
	FeatureViewId string `position:"Path" name:"FeatureViewId"`
}

// ListFeatureViewOnlineFeaturesResponse is the response struct for api ListFeatureViewOnlineFeatures
type ListFeatureViewOnlineFeaturesResponse struct {
	*responses.BaseResponse
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	OnlineFeatures []string `json:"OnlineFeatures" xml:"OnlineFeatures"`
}

// CreateListFeatureViewOnlineFeaturesRequest creates a request to invoke ListFeatureViewOnlineFeatures API
func CreateListFeatureViewOnlineFeaturesRequest() (request *ListFeatureViewOnlineFeaturesRequest) {
	request = &ListFeatureViewOnlineFeaturesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiFeatureStore", "2023-06-21", "ListFeatureViewOnlineFeatures", "/api/v1/instances/[InstanceId]/featureviews/[FeatureViewId]/onlinefeatures", "", "")
	request.Method = requests.GET
	return
}

// CreateListFeatureViewOnlineFeaturesResponse creates a response to parse from ListFeatureViewOnlineFeatures response
func CreateListFeatureViewOnlineFeaturesResponse() (response *ListFeatureViewOnlineFeaturesResponse) {
	response = &ListFeatureViewOnlineFeaturesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
