package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSecurityIpGroups invokes the oceanbasepro.DescribeSecurityIpGroups API synchronously
func (client *Client) DescribeSecurityIpGroups(request *DescribeSecurityIpGroupsRequest) (response *DescribeSecurityIpGroupsResponse, err error) {
	response = CreateDescribeSecurityIpGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSecurityIpGroupsWithChan invokes the oceanbasepro.DescribeSecurityIpGroups API asynchronously
func (client *Client) DescribeSecurityIpGroupsWithChan(request *DescribeSecurityIpGroupsRequest) (<-chan *DescribeSecurityIpGroupsResponse, <-chan error) {
	responseChan := make(chan *DescribeSecurityIpGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSecurityIpGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSecurityIpGroupsWithCallback invokes the oceanbasepro.DescribeSecurityIpGroups API asynchronously
func (client *Client) DescribeSecurityIpGroupsWithCallback(request *DescribeSecurityIpGroupsRequest, callback func(response *DescribeSecurityIpGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSecurityIpGroupsResponse
		var err error
		defer close(result)
		response, err = client.DescribeSecurityIpGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSecurityIpGroupsRequest is the request struct for api DescribeSecurityIpGroups
type DescribeSecurityIpGroupsRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Body" name:"InstanceId"`
}

// DescribeSecurityIpGroupsResponse is the response struct for api DescribeSecurityIpGroups
type DescribeSecurityIpGroupsResponse struct {
	*responses.BaseResponse
	RequestId        string                 `json:"RequestId" xml:"RequestId"`
	TotalCount       int                    `json:"TotalCount" xml:"TotalCount"`
	SecurityIpGroups []SecurityIpGroupsItem `json:"SecurityIpGroups" xml:"SecurityIpGroups"`
}

// CreateDescribeSecurityIpGroupsRequest creates a request to invoke DescribeSecurityIpGroups API
func CreateDescribeSecurityIpGroupsRequest() (request *DescribeSecurityIpGroupsRequest) {
	request = &DescribeSecurityIpGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeSecurityIpGroups", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSecurityIpGroupsResponse creates a response to parse from DescribeSecurityIpGroups response
func CreateDescribeSecurityIpGroupsResponse() (response *DescribeSecurityIpGroupsResponse) {
	response = &DescribeSecurityIpGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
