package objectdet

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetectWhiteBaseImage invokes the objectdet.DetectWhiteBaseImage API synchronously
func (client *Client) DetectWhiteBaseImage(request *DetectWhiteBaseImageRequest) (response *DetectWhiteBaseImageResponse, err error) {
	response = CreateDetectWhiteBaseImageResponse()
	err = client.DoAction(request, response)
	return
}

// DetectWhiteBaseImageWithChan invokes the objectdet.DetectWhiteBaseImage API asynchronously
func (client *Client) DetectWhiteBaseImageWithChan(request *DetectWhiteBaseImageRequest) (<-chan *DetectWhiteBaseImageResponse, <-chan error) {
	responseChan := make(chan *DetectWhiteBaseImageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetectWhiteBaseImage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetectWhiteBaseImageWithCallback invokes the objectdet.DetectWhiteBaseImage API asynchronously
func (client *Client) DetectWhiteBaseImageWithCallback(request *DetectWhiteBaseImageRequest, callback func(response *DetectWhiteBaseImageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetectWhiteBaseImageResponse
		var err error
		defer close(result)
		response, err = client.DetectWhiteBaseImage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetectWhiteBaseImageRequest is the request struct for api DetectWhiteBaseImage
type DetectWhiteBaseImageRequest struct {
	*requests.RpcRequest
	ImageURL string `position:"Body" name:"ImageURL"`
}

// DetectWhiteBaseImageResponse is the response struct for api DetectWhiteBaseImage
type DetectWhiteBaseImageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDetectWhiteBaseImageRequest creates a request to invoke DetectWhiteBaseImage API
func CreateDetectWhiteBaseImageRequest() (request *DetectWhiteBaseImageRequest) {
	request = &DetectWhiteBaseImageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("objectdet", "2019-12-30", "DetectWhiteBaseImage", "objectdet", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetectWhiteBaseImageResponse creates a response to parse from DetectWhiteBaseImage response
func CreateDetectWhiteBaseImageResponse() (response *DetectWhiteBaseImageResponse) {
	response = &DetectWhiteBaseImageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
