package mseap

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAgreementStatus invokes the mseap.DescribeAgreementStatus API synchronously
func (client *Client) DescribeAgreementStatus(request *DescribeAgreementStatusRequest) (response *DescribeAgreementStatusResponse, err error) {
	response = CreateDescribeAgreementStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAgreementStatusWithChan invokes the mseap.DescribeAgreementStatus API asynchronously
func (client *Client) DescribeAgreementStatusWithChan(request *DescribeAgreementStatusRequest) (<-chan *DescribeAgreementStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeAgreementStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAgreementStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAgreementStatusWithCallback invokes the mseap.DescribeAgreementStatus API asynchronously
func (client *Client) DescribeAgreementStatusWithCallback(request *DescribeAgreementStatusRequest, callback func(response *DescribeAgreementStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAgreementStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeAgreementStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAgreementStatusRequest is the request struct for api DescribeAgreementStatus
type DescribeAgreementStatusRequest struct {
	*requests.RpcRequest
	AgreementCode string `position:"Query" name:"AgreementCode"`
}

// DescribeAgreementStatusResponse is the response struct for api DescribeAgreementStatus
type DescribeAgreementStatusResponse struct {
	*responses.BaseResponse
	Status        int    `json:"Status" xml:"Status"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
	AgreementCode string `json:"AgreementCode" xml:"AgreementCode"`
	UserId        string `json:"UserId" xml:"UserId"`
}

// CreateDescribeAgreementStatusRequest creates a request to invoke DescribeAgreementStatus API
func CreateDescribeAgreementStatusRequest() (request *DescribeAgreementStatusRequest) {
	request = &DescribeAgreementStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mseap", "2021-01-18", "DescribeAgreementStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeAgreementStatusResponse creates a response to parse from DescribeAgreementStatus response
func CreateDescribeAgreementStatusResponse() (response *DescribeAgreementStatusResponse) {
	response = &DescribeAgreementStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
