package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PreserveHeaderFormat invokes the mse.PreserveHeaderFormat API synchronously
func (client *Client) PreserveHeaderFormat(request *PreserveHeaderFormatRequest) (response *PreserveHeaderFormatResponse, err error) {
	response = CreatePreserveHeaderFormatResponse()
	err = client.DoAction(request, response)
	return
}

// PreserveHeaderFormatWithChan invokes the mse.PreserveHeaderFormat API asynchronously
func (client *Client) PreserveHeaderFormatWithChan(request *PreserveHeaderFormatRequest) (<-chan *PreserveHeaderFormatResponse, <-chan error) {
	responseChan := make(chan *PreserveHeaderFormatResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PreserveHeaderFormat(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PreserveHeaderFormatWithCallback invokes the mse.PreserveHeaderFormat API asynchronously
func (client *Client) PreserveHeaderFormatWithCallback(request *PreserveHeaderFormatRequest, callback func(response *PreserveHeaderFormatResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PreserveHeaderFormatResponse
		var err error
		defer close(result)
		response, err = client.PreserveHeaderFormat(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PreserveHeaderFormatRequest is the request struct for api PreserveHeaderFormat
type PreserveHeaderFormatRequest struct {
	*requests.RpcRequest
	MseSessionId         string           `position:"Query" name:"MseSessionId"`
	GatewayUniqueId      string           `position:"Query" name:"GatewayUniqueId"`
	AcceptLanguage       string           `position:"Query" name:"AcceptLanguage"`
	PreserveHeaderFormat requests.Boolean `position:"Query" name:"PreserveHeaderFormat"`
}

// PreserveHeaderFormatResponse is the response struct for api PreserveHeaderFormat
type PreserveHeaderFormatResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           int    `json:"Code" xml:"Code"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	Data           bool   `json:"Data" xml:"Data"`
}

// CreatePreserveHeaderFormatRequest creates a request to invoke PreserveHeaderFormat API
func CreatePreserveHeaderFormatRequest() (request *PreserveHeaderFormatRequest) {
	request = &PreserveHeaderFormatRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "PreserveHeaderFormat", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePreserveHeaderFormatResponse creates a response to parse from PreserveHeaderFormat response
func CreatePreserveHeaderFormatResponse() (response *PreserveHeaderFormatResponse) {
	response = &PreserveHeaderFormatResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
