package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMcubeNebulaResource invokes the mpaas.GetMcubeNebulaResource API synchronously
func (client *Client) GetMcubeNebulaResource(request *GetMcubeNebulaResourceRequest) (response *GetMcubeNebulaResourceResponse, err error) {
	response = CreateGetMcubeNebulaResourceResponse()
	err = client.DoAction(request, response)
	return
}

// GetMcubeNebulaResourceWithChan invokes the mpaas.GetMcubeNebulaResource API asynchronously
func (client *Client) GetMcubeNebulaResourceWithChan(request *GetMcubeNebulaResourceRequest) (<-chan *GetMcubeNebulaResourceResponse, <-chan error) {
	responseChan := make(chan *GetMcubeNebulaResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMcubeNebulaResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMcubeNebulaResourceWithCallback invokes the mpaas.GetMcubeNebulaResource API asynchronously
func (client *Client) GetMcubeNebulaResourceWithCallback(request *GetMcubeNebulaResourceRequest, callback func(response *GetMcubeNebulaResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMcubeNebulaResourceResponse
		var err error
		defer close(result)
		response, err = client.GetMcubeNebulaResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMcubeNebulaResourceRequest is the request struct for api GetMcubeNebulaResource
type GetMcubeNebulaResourceRequest struct {
	*requests.RpcRequest
	TenantId    string `position:"Body" name:"TenantId"`
	Id          string `position:"Body" name:"Id"`
	AppId       string `position:"Body" name:"AppId"`
	WorkspaceId string `position:"Body" name:"WorkspaceId"`
}

// GetMcubeNebulaResourceResponse is the response struct for api GetMcubeNebulaResource
type GetMcubeNebulaResourceResponse struct {
	*responses.BaseResponse
	ResultMessage           string                  `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode              string                  `json:"ResultCode" xml:"ResultCode"`
	RequestId               string                  `json:"RequestId" xml:"RequestId"`
	GetNebulaResourceResult GetNebulaResourceResult `json:"GetNebulaResourceResult" xml:"GetNebulaResourceResult"`
}

// CreateGetMcubeNebulaResourceRequest creates a request to invoke GetMcubeNebulaResource API
func CreateGetMcubeNebulaResourceRequest() (request *GetMcubeNebulaResourceRequest) {
	request = &GetMcubeNebulaResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "GetMcubeNebulaResource", "", "")
	request.Method = requests.POST
	return
}

// CreateGetMcubeNebulaResourceResponse creates a response to parse from GetMcubeNebulaResource response
func CreateGetMcubeNebulaResourceResponse() (response *GetMcubeNebulaResourceResponse) {
	response = &GetMcubeNebulaResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
