package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMsacAppInstance invokes the mpaas.CreateMsacAppInstance API synchronously
func (client *Client) CreateMsacAppInstance(request *CreateMsacAppInstanceRequest) (response *CreateMsacAppInstanceResponse, err error) {
	response = CreateCreateMsacAppInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMsacAppInstanceWithChan invokes the mpaas.CreateMsacAppInstance API asynchronously
func (client *Client) CreateMsacAppInstanceWithChan(request *CreateMsacAppInstanceRequest) (<-chan *CreateMsacAppInstanceResponse, <-chan error) {
	responseChan := make(chan *CreateMsacAppInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMsacAppInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMsacAppInstanceWithCallback invokes the mpaas.CreateMsacAppInstance API asynchronously
func (client *Client) CreateMsacAppInstanceWithCallback(request *CreateMsacAppInstanceRequest, callback func(response *CreateMsacAppInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMsacAppInstanceResponse
		var err error
		defer close(result)
		response, err = client.CreateMsacAppInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMsacAppInstanceRequest is the request struct for api CreateMsacAppInstance
type CreateMsacAppInstanceRequest struct {
	*requests.RpcRequest
	MpaasMappcenterMsacCreateAppInstanceJsonStr string `position:"Body" name:"MpaasMappcenterMsacCreateAppInstanceJsonStr"`
	TenantId                                    string `position:"Body" name:"TenantId"`
	AppId                                       string `position:"Body" name:"AppId"`
	WorkspaceId                                 string `position:"Body" name:"WorkspaceId"`
}

// CreateMsacAppInstanceResponse is the response struct for api CreateMsacAppInstance
type CreateMsacAppInstanceResponse struct {
	*responses.BaseResponse
	ResultMessage string                               `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string                               `json:"ResultCode" xml:"ResultCode"`
	RequestId     string                               `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContentInCreateMsacAppInstance `json:"ResultContent" xml:"ResultContent"`
}

// CreateCreateMsacAppInstanceRequest creates a request to invoke CreateMsacAppInstance API
func CreateCreateMsacAppInstanceRequest() (request *CreateMsacAppInstanceRequest) {
	request = &CreateMsacAppInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "CreateMsacAppInstance", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateMsacAppInstanceResponse creates a response to parse from CreateMsacAppInstance response
func CreateCreateMsacAppInstanceResponse() (response *CreateMsacAppInstanceResponse) {
	response = &CreateMsacAppInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
