package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListEdgeDevice invokes the lto.ListEdgeDevice API synchronously
func (client *Client) ListEdgeDevice(request *ListEdgeDeviceRequest) (response *ListEdgeDeviceResponse, err error) {
	response = CreateListEdgeDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// ListEdgeDeviceWithChan invokes the lto.ListEdgeDevice API asynchronously
func (client *Client) ListEdgeDeviceWithChan(request *ListEdgeDeviceRequest) (<-chan *ListEdgeDeviceResponse, <-chan error) {
	responseChan := make(chan *ListEdgeDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListEdgeDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListEdgeDeviceWithCallback invokes the lto.ListEdgeDevice API asynchronously
func (client *Client) ListEdgeDeviceWithCallback(request *ListEdgeDeviceRequest, callback func(response *ListEdgeDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListEdgeDeviceResponse
		var err error
		defer close(result)
		response, err = client.ListEdgeDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListEdgeDeviceRequest is the request struct for api ListEdgeDevice
type ListEdgeDeviceRequest struct {
	*requests.RpcRequest
	Num        requests.Integer `position:"Query" name:"Num"`
	ProductKey string           `position:"Query" name:"ProductKey"`
	Size       requests.Integer `position:"Query" name:"Size"`
	Name       string           `position:"Query" name:"Name"`
}

// ListEdgeDeviceResponse is the response struct for api ListEdgeDevice
type ListEdgeDeviceResponse struct {
	*responses.BaseResponse
	Code           string               `json:"Code" xml:"Code"`
	HttpStatusCode int                  `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string               `json:"Message" xml:"Message"`
	RequestId      string               `json:"RequestId" xml:"RequestId"`
	Success        bool                 `json:"Success" xml:"Success"`
	Data           DataInListEdgeDevice `json:"Data" xml:"Data"`
}

// CreateListEdgeDeviceRequest creates a request to invoke ListEdgeDevice API
func CreateListEdgeDeviceRequest() (request *ListEdgeDeviceRequest) {
	request = &ListEdgeDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "ListEdgeDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateListEdgeDeviceResponse creates a response to parse from ListEdgeDevice response
func CreateListEdgeDeviceResponse() (response *ListEdgeDeviceResponse) {
	response = &ListEdgeDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
