package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyLiveMessageGroup invokes the live.ModifyLiveMessageGroup API synchronously
func (client *Client) ModifyLiveMessageGroup(request *ModifyLiveMessageGroupRequest) (response *ModifyLiveMessageGroupResponse, err error) {
	response = CreateModifyLiveMessageGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyLiveMessageGroupWithChan invokes the live.ModifyLiveMessageGroup API asynchronously
func (client *Client) ModifyLiveMessageGroupWithChan(request *ModifyLiveMessageGroupRequest) (<-chan *ModifyLiveMessageGroupResponse, <-chan error) {
	responseChan := make(chan *ModifyLiveMessageGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyLiveMessageGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyLiveMessageGroupWithCallback invokes the live.ModifyLiveMessageGroup API asynchronously
func (client *Client) ModifyLiveMessageGroupWithCallback(request *ModifyLiveMessageGroupRequest, callback func(response *ModifyLiveMessageGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyLiveMessageGroupResponse
		var err error
		defer close(result)
		response, err = client.ModifyLiveMessageGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyLiveMessageGroupRequest is the request struct for api ModifyLiveMessageGroup
type ModifyLiveMessageGroupRequest struct {
	*requests.RpcRequest
	GroupId     string           `position:"Query" name:"GroupId"`
	GroupInfo   string           `position:"Query" name:"GroupInfo"`
	DataCenter  string           `position:"Query" name:"DataCenter"`
	ModifyInfo  requests.Boolean `position:"Query" name:"ModifyInfo"`
	AdminList   *[]string        `position:"Query" name:"AdminList"  type:"Repeated"`
	AppId       string           `position:"Query" name:"AppId"`
	ModifyAdmin requests.Boolean `position:"Query" name:"ModifyAdmin"`
}

// ModifyLiveMessageGroupResponse is the response struct for api ModifyLiveMessageGroup
type ModifyLiveMessageGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyLiveMessageGroupRequest creates a request to invoke ModifyLiveMessageGroup API
func CreateModifyLiveMessageGroupRequest() (request *ModifyLiveMessageGroupRequest) {
	request = &ModifyLiveMessageGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "ModifyLiveMessageGroup", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyLiveMessageGroupResponse creates a response to parse from ModifyLiveMessageGroup response
func CreateModifyLiveMessageGroupResponse() (response *ModifyLiveMessageGroupResponse) {
	response = &ModifyLiveMessageGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
