package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListNotifications invokes the linkwan.ListNotifications API synchronously
func (client *Client) ListNotifications(request *ListNotificationsRequest) (response *ListNotificationsResponse, err error) {
	response = CreateListNotificationsResponse()
	err = client.DoAction(request, response)
	return
}

// ListNotificationsWithChan invokes the linkwan.ListNotifications API asynchronously
func (client *Client) ListNotificationsWithChan(request *ListNotificationsRequest) (<-chan *ListNotificationsResponse, <-chan error) {
	responseChan := make(chan *ListNotificationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListNotifications(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListNotificationsWithCallback invokes the linkwan.ListNotifications API asynchronously
func (client *Client) ListNotificationsWithCallback(request *ListNotificationsRequest, callback func(response *ListNotificationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListNotificationsResponse
		var err error
		defer close(result)
		response, err = client.ListNotifications(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListNotificationsRequest is the request struct for api ListNotifications
type ListNotificationsRequest struct {
	*requests.RpcRequest
	EndMillis    requests.Integer `position:"Query" name:"EndMillis"`
	Limit        requests.Integer `position:"Query" name:"Limit"`
	Offset       requests.Integer `position:"Query" name:"Offset"`
	Ascending    requests.Boolean `position:"Query" name:"Ascending"`
	HandleState  string           `position:"Query" name:"HandleState"`
	ApiProduct   string           `position:"Body" name:"ApiProduct"`
	ApiRevision  string           `position:"Body" name:"ApiRevision"`
	Category     *[]string        `position:"Query" name:"Category"  type:"Repeated"`
	BeginMillis  requests.Integer `position:"Query" name:"BeginMillis"`
	SortingField string           `position:"Query" name:"SortingField"`
}

// ListNotificationsResponse is the response struct for api ListNotifications
type ListNotificationsResponse struct {
	*responses.BaseResponse
	RequestId string                  `json:"RequestId" xml:"RequestId"`
	Success   bool                    `json:"Success" xml:"Success"`
	Data      DataInListNotifications `json:"Data" xml:"Data"`
}

// CreateListNotificationsRequest creates a request to invoke ListNotifications API
func CreateListNotificationsRequest() (request *ListNotificationsRequest) {
	request = &ListNotificationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "ListNotifications", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListNotificationsResponse creates a response to parse from ListNotifications response
func CreateListNotificationsResponse() (response *ListNotificationsResponse) {
	response = &ListNotificationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
