package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTimeTemplate invokes the linkvisual.UpdateTimeTemplate API synchronously
func (client *Client) UpdateTimeTemplate(request *UpdateTimeTemplateRequest) (response *UpdateTimeTemplateResponse, err error) {
	response = CreateUpdateTimeTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTimeTemplateWithChan invokes the linkvisual.UpdateTimeTemplate API asynchronously
func (client *Client) UpdateTimeTemplateWithChan(request *UpdateTimeTemplateRequest) (<-chan *UpdateTimeTemplateResponse, <-chan error) {
	responseChan := make(chan *UpdateTimeTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTimeTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTimeTemplateWithCallback invokes the linkvisual.UpdateTimeTemplate API asynchronously
func (client *Client) UpdateTimeTemplateWithCallback(request *UpdateTimeTemplateRequest, callback func(response *UpdateTimeTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTimeTemplateResponse
		var err error
		defer close(result)
		response, err = client.UpdateTimeTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTimeTemplateRequest is the request struct for api UpdateTimeTemplate
type UpdateTimeTemplateRequest struct {
	*requests.RpcRequest
	TimeSections *[]UpdateTimeTemplateTimeSections `position:"Query" name:"TimeSections"  type:"Repeated"`
	TemplateId   string                            `position:"Query" name:"TemplateId"`
	AllDay       requests.Integer                  `position:"Query" name:"AllDay"`
	ApiProduct   string                            `position:"Body" name:"ApiProduct"`
	Name         string                            `position:"Query" name:"Name"`
	ApiRevision  string                            `position:"Body" name:"ApiRevision"`
}

// UpdateTimeTemplateTimeSections is a repeated param struct in UpdateTimeTemplateRequest
type UpdateTimeTemplateTimeSections struct {
	DayOfWeek string `name:"DayOfWeek"`
	Begin     string `name:"Begin"`
	End       string `name:"End"`
}

// UpdateTimeTemplateResponse is the response struct for api UpdateTimeTemplate
type UpdateTimeTemplateResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateUpdateTimeTemplateRequest creates a request to invoke UpdateTimeTemplate API
func CreateUpdateTimeTemplateRequest() (request *UpdateTimeTemplateRequest) {
	request = &UpdateTimeTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "UpdateTimeTemplate", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateTimeTemplateResponse creates a response to parse from UpdateTimeTemplate response
func CreateUpdateTimeTemplateResponse() (response *UpdateTimeTemplateResponse) {
	response = &UpdateTimeTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
