package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchQueryVisionDeviceInfo invokes the linkvisual.BatchQueryVisionDeviceInfo API synchronously
func (client *Client) BatchQueryVisionDeviceInfo(request *BatchQueryVisionDeviceInfoRequest) (response *BatchQueryVisionDeviceInfoResponse, err error) {
	response = CreateBatchQueryVisionDeviceInfoResponse()
	err = client.DoAction(request, response)
	return
}

// BatchQueryVisionDeviceInfoWithChan invokes the linkvisual.BatchQueryVisionDeviceInfo API asynchronously
func (client *Client) BatchQueryVisionDeviceInfoWithChan(request *BatchQueryVisionDeviceInfoRequest) (<-chan *BatchQueryVisionDeviceInfoResponse, <-chan error) {
	responseChan := make(chan *BatchQueryVisionDeviceInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchQueryVisionDeviceInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchQueryVisionDeviceInfoWithCallback invokes the linkvisual.BatchQueryVisionDeviceInfo API asynchronously
func (client *Client) BatchQueryVisionDeviceInfoWithCallback(request *BatchQueryVisionDeviceInfoRequest, callback func(response *BatchQueryVisionDeviceInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchQueryVisionDeviceInfoResponse
		var err error
		defer close(result)
		response, err = client.BatchQueryVisionDeviceInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchQueryVisionDeviceInfoRequest is the request struct for api BatchQueryVisionDeviceInfo
type BatchQueryVisionDeviceInfoRequest struct {
	*requests.RpcRequest
	DeviceNameList *[]string `position:"Query" name:"DeviceNameList"  type:"Repeated"`
	IotInstanceId  string    `position:"Query" name:"IotInstanceId"`
	IotIdList      *[]string `position:"Query" name:"IotIdList"  type:"Repeated"`
	ProductKey     string    `position:"Query" name:"ProductKey"`
	ApiProduct     string    `position:"Body" name:"ApiProduct"`
	ApiRevision    string    `position:"Body" name:"ApiRevision"`
}

// BatchQueryVisionDeviceInfoResponse is the response struct for api BatchQueryVisionDeviceInfo
type BatchQueryVisionDeviceInfoResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateBatchQueryVisionDeviceInfoRequest creates a request to invoke BatchQueryVisionDeviceInfo API
func CreateBatchQueryVisionDeviceInfoRequest() (request *BatchQueryVisionDeviceInfoRequest) {
	request = &BatchQueryVisionDeviceInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "BatchQueryVisionDeviceInfo", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBatchQueryVisionDeviceInfoResponse creates a response to parse from BatchQueryVisionDeviceInfo response
func CreateBatchQueryVisionDeviceInfoResponse() (response *BatchQueryVisionDeviceInfoResponse) {
	response = &BatchQueryVisionDeviceInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
