package ledgerdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMember invokes the ledgerdb.DeleteMember API synchronously
// api document: https://help.aliyun.com/api/ledgerdb/deletemember.html
func (client *Client) DeleteMember(request *DeleteMemberRequest) (response *DeleteMemberResponse, err error) {
	response = CreateDeleteMemberResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMemberWithChan invokes the ledgerdb.DeleteMember API asynchronously
// api document: https://help.aliyun.com/api/ledgerdb/deletemember.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteMemberWithChan(request *DeleteMemberRequest) (<-chan *DeleteMemberResponse, <-chan error) {
	responseChan := make(chan *DeleteMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMemberWithCallback invokes the ledgerdb.DeleteMember API asynchronously
// api document: https://help.aliyun.com/api/ledgerdb/deletemember.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteMemberWithCallback(request *DeleteMemberRequest, callback func(response *DeleteMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMemberResponse
		var err error
		defer close(result)
		response, err = client.DeleteMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMemberRequest is the request struct for api DeleteMember
type DeleteMemberRequest struct {
	*requests.RpcRequest
	LedgerId string `position:"Query" name:"LedgerId"`
	MemberId string `position:"Query" name:"MemberId"`
}

// DeleteMemberResponse is the response struct for api DeleteMember
type DeleteMemberResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteMemberRequest creates a request to invoke DeleteMember API
func CreateDeleteMemberRequest() (request *DeleteMemberRequest) {
	request = &DeleteMemberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ledgerdb", "2019-11-22", "DeleteMember", "ledgerdb", "openAPI")
	return
}

// CreateDeleteMemberResponse creates a response to parse from DeleteMember response
func CreateDeleteMemberResponse() (response *DeleteMemberResponse) {
	response = &DeleteMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
