package jarvis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCdnIpList invokes the jarvis.DescribeCdnIpList API synchronously
// api document: https://help.aliyun.com/api/jarvis/describecdniplist.html
func (client *Client) DescribeCdnIpList(request *DescribeCdnIpListRequest) (response *DescribeCdnIpListResponse, err error) {
	response = CreateDescribeCdnIpListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCdnIpListWithChan invokes the jarvis.DescribeCdnIpList API asynchronously
// api document: https://help.aliyun.com/api/jarvis/describecdniplist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCdnIpListWithChan(request *DescribeCdnIpListRequest) (<-chan *DescribeCdnIpListResponse, <-chan error) {
	responseChan := make(chan *DescribeCdnIpListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCdnIpList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCdnIpListWithCallback invokes the jarvis.DescribeCdnIpList API asynchronously
// api document: https://help.aliyun.com/api/jarvis/describecdniplist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCdnIpListWithCallback(request *DescribeCdnIpListRequest, callback func(response *DescribeCdnIpListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCdnIpListResponse
		var err error
		defer close(result)
		response, err = client.DescribeCdnIpList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCdnIpListRequest is the request struct for api DescribeCdnIpList
type DescribeCdnIpListRequest struct {
	*requests.RpcRequest
	SrcIP       string           `position:"Query" name:"SrcIP"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	WlState     requests.Integer `position:"Query" name:"WlState"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	Lang        string           `position:"Query" name:"Lang"`
	SourceCode  string           `position:"Query" name:"SourceCode"`
}

// DescribeCdnIpListResponse is the response struct for api DescribeCdnIpList
type DescribeCdnIpListResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Module    string   `json:"Module" xml:"Module"`
	PageInfo  PageInfo `json:"PageInfo" xml:"PageInfo"`
	DataList  []Data   `json:"DataList" xml:"DataList"`
}

// CreateDescribeCdnIpListRequest creates a request to invoke DescribeCdnIpList API
func CreateDescribeCdnIpListRequest() (request *DescribeCdnIpListRequest) {
	request = &DescribeCdnIpListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("jarvis", "2018-02-06", "DescribeCdnIpList", "jarvis", "openAPI")
	return
}

// CreateDescribeCdnIpListResponse creates a response to parse from DescribeCdnIpList response
func CreateDescribeCdnIpListResponse() (response *DescribeCdnIpListResponse) {
	response = &DescribeCdnIpListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
