package ivpd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAsyncResult invokes the ivpd.GetAsyncResult API synchronously
// api document: https://help.aliyun.com/api/ivpd/getasyncresult.html
func (client *Client) GetAsyncResult(request *GetAsyncResultRequest) (response *GetAsyncResultResponse, err error) {
	response = CreateGetAsyncResultResponse()
	err = client.DoAction(request, response)
	return
}

// GetAsyncResultWithChan invokes the ivpd.GetAsyncResult API asynchronously
// api document: https://help.aliyun.com/api/ivpd/getasyncresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetAsyncResultWithChan(request *GetAsyncResultRequest) (<-chan *GetAsyncResultResponse, <-chan error) {
	responseChan := make(chan *GetAsyncResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAsyncResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAsyncResultWithCallback invokes the ivpd.GetAsyncResult API asynchronously
// api document: https://help.aliyun.com/api/ivpd/getasyncresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetAsyncResultWithCallback(request *GetAsyncResultRequest, callback func(response *GetAsyncResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAsyncResultResponse
		var err error
		defer close(result)
		response, err = client.GetAsyncResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAsyncResultRequest is the request struct for api GetAsyncResult
type GetAsyncResultRequest struct {
	*requests.RpcRequest
	JobId string `position:"Body" name:"JobId"`
}

// GetAsyncResultResponse is the response struct for api GetAsyncResult
type GetAsyncResultResponse struct {
	*responses.BaseResponse
	RequestId string               `json:"RequestId" xml:"RequestId"`
	Code      string               `json:"Code" xml:"Code"`
	Message   string               `json:"Message" xml:"Message"`
	Data      DataInGetAsyncResult `json:"Data" xml:"Data"`
}

// CreateGetAsyncResultRequest creates a request to invoke GetAsyncResult API
func CreateGetAsyncResultRequest() (request *GetAsyncResultRequest) {
	request = &GetAsyncResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ivpd", "2019-06-25", "GetAsyncResult", "ivpd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetAsyncResultResponse creates a response to parse from GetAsyncResult response
func CreateGetAsyncResultResponse() (response *GetAsyncResultResponse) {
	response = &GetAsyncResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
