package ivision

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopStreamPredict invokes the ivision.StopStreamPredict API synchronously
func (client *Client) StopStreamPredict(request *StopStreamPredictRequest) (response *StopStreamPredictResponse, err error) {
	response = CreateStopStreamPredictResponse()
	err = client.DoAction(request, response)
	return
}

// StopStreamPredictWithChan invokes the ivision.StopStreamPredict API asynchronously
func (client *Client) StopStreamPredictWithChan(request *StopStreamPredictRequest) (<-chan *StopStreamPredictResponse, <-chan error) {
	responseChan := make(chan *StopStreamPredictResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopStreamPredict(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopStreamPredictWithCallback invokes the ivision.StopStreamPredict API asynchronously
func (client *Client) StopStreamPredictWithCallback(request *StopStreamPredictRequest, callback func(response *StopStreamPredictResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopStreamPredictResponse
		var err error
		defer close(result)
		response, err = client.StopStreamPredict(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopStreamPredictRequest is the request struct for api StopStreamPredict
type StopStreamPredictRequest struct {
	*requests.RpcRequest
	PredictId string           `position:"Query" name:"PredictId"`
	ShowLog   string           `position:"Query" name:"ShowLog"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
}

// StopStreamPredictResponse is the response struct for api StopStreamPredict
type StopStreamPredictResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	PredictId string `json:"PredictId" xml:"PredictId"`
}

// CreateStopStreamPredictRequest creates a request to invoke StopStreamPredict API
func CreateStopStreamPredictRequest() (request *StopStreamPredictRequest) {
	request = &StopStreamPredictRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ivision", "2019-03-08", "StopStreamPredict", "ivision", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStopStreamPredictResponse creates a response to parse from StopStreamPredict response
func CreateStopStreamPredictResponse() (response *StopStreamPredictResponse) {
	response = &StopStreamPredictResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
