package ims

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCredentialReport invokes the ims.GetCredentialReport API synchronously
func (client *Client) GetCredentialReport(request *GetCredentialReportRequest) (response *GetCredentialReportResponse, err error) {
	response = CreateGetCredentialReportResponse()
	err = client.DoAction(request, response)
	return
}

// GetCredentialReportWithChan invokes the ims.GetCredentialReport API asynchronously
func (client *Client) GetCredentialReportWithChan(request *GetCredentialReportRequest) (<-chan *GetCredentialReportResponse, <-chan error) {
	responseChan := make(chan *GetCredentialReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCredentialReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCredentialReportWithCallback invokes the ims.GetCredentialReport API asynchronously
func (client *Client) GetCredentialReportWithCallback(request *GetCredentialReportRequest, callback func(response *GetCredentialReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCredentialReportResponse
		var err error
		defer close(result)
		response, err = client.GetCredentialReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCredentialReportRequest is the request struct for api GetCredentialReport
type GetCredentialReportRequest struct {
	*requests.RpcRequest
	AkProxySuffix string `position:"Query" name:"AkProxySuffix"`
	NextToken     string `position:"Query" name:"NextToken"`
	MaxItems      string `position:"Query" name:"MaxItems"`
}

// GetCredentialReportResponse is the response struct for api GetCredentialReport
type GetCredentialReportResponse struct {
	*responses.BaseResponse
	GeneratedTime string `json:"GeneratedTime" xml:"GeneratedTime"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
	Content       string `json:"Content" xml:"Content"`
	IsTruncated   string `json:"IsTruncated" xml:"IsTruncated"`
	NextToken     string `json:"NextToken" xml:"NextToken"`
}

// CreateGetCredentialReportRequest creates a request to invoke GetCredentialReport API
func CreateGetCredentialReportRequest() (request *GetCredentialReportRequest) {
	request = &GetCredentialReportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ims", "2019-08-15", "GetCredentialReport", "ims", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetCredentialReportResponse creates a response to parse from GetCredentialReport response
func CreateGetCredentialReportResponse() (response *GetCredentialReportResponse) {
	response = &GetCredentialReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
