package ims

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteOIDCProvider invokes the ims.DeleteOIDCProvider API synchronously
func (client *Client) DeleteOIDCProvider(request *DeleteOIDCProviderRequest) (response *DeleteOIDCProviderResponse, err error) {
	response = CreateDeleteOIDCProviderResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteOIDCProviderWithChan invokes the ims.DeleteOIDCProvider API asynchronously
func (client *Client) DeleteOIDCProviderWithChan(request *DeleteOIDCProviderRequest) (<-chan *DeleteOIDCProviderResponse, <-chan error) {
	responseChan := make(chan *DeleteOIDCProviderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteOIDCProvider(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteOIDCProviderWithCallback invokes the ims.DeleteOIDCProvider API asynchronously
func (client *Client) DeleteOIDCProviderWithCallback(request *DeleteOIDCProviderRequest, callback func(response *DeleteOIDCProviderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteOIDCProviderResponse
		var err error
		defer close(result)
		response, err = client.DeleteOIDCProvider(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteOIDCProviderRequest is the request struct for api DeleteOIDCProvider
type DeleteOIDCProviderRequest struct {
	*requests.RpcRequest
	AkProxySuffix    string `position:"Query" name:"AkProxySuffix"`
	OIDCProviderName string `position:"Query" name:"OIDCProviderName"`
}

// DeleteOIDCProviderResponse is the response struct for api DeleteOIDCProvider
type DeleteOIDCProviderResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteOIDCProviderRequest creates a request to invoke DeleteOIDCProvider API
func CreateDeleteOIDCProviderRequest() (request *DeleteOIDCProviderRequest) {
	request = &DeleteOIDCProviderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ims", "2019-08-15", "DeleteOIDCProvider", "ims", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteOIDCProviderResponse creates a response to parse from DeleteOIDCProvider response
func CreateDeleteOIDCProviderResponse() (response *DeleteOIDCProviderResponse) {
	response = &DeleteOIDCProviderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
