package imagesearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SearchImage invokes the imagesearch.SearchImage API synchronously
// api document: https://help.aliyun.com/api/imagesearch/searchimage.html
func (client *Client) SearchImage(request *SearchImageRequest) (response *SearchImageResponse, err error) {
	response = CreateSearchImageResponse()
	err = client.DoAction(request, response)
	return
}

// SearchImageWithChan invokes the imagesearch.SearchImage API asynchronously
// api document: https://help.aliyun.com/api/imagesearch/searchimage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SearchImageWithChan(request *SearchImageRequest) (<-chan *SearchImageResponse, <-chan error) {
	responseChan := make(chan *SearchImageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SearchImage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SearchImageWithCallback invokes the imagesearch.SearchImage API asynchronously
// api document: https://help.aliyun.com/api/imagesearch/searchimage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SearchImageWithCallback(request *SearchImageRequest, callback func(response *SearchImageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SearchImageResponse
		var err error
		defer close(result)
		response, err = client.SearchImage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SearchImageRequest is the request struct for api SearchImage
type SearchImageRequest struct {
	*requests.RoaRequest
	Filter       string           `position:"Body" name:"Filter"`
	PicContent   string           `position:"Body" name:"PicContent"`
	InstanceName string           `position:"Body" name:"InstanceName"`
	ProductId    string           `position:"Body" name:"ProductId"`
	Num          requests.Integer `position:"Body" name:"Num"`
	PicName      string           `position:"Body" name:"PicName"`
	Start        requests.Integer `position:"Body" name:"Start"`
	Region       string           `position:"Body" name:"Region"`
	Type         string           `position:"Body" name:"Type"`
	CategoryId   requests.Integer `position:"Body" name:"CategoryId"`
	Crop         requests.Boolean `position:"Body" name:"Crop"`
}

// SearchImageResponse is the response struct for api SearchImage
type SearchImageResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Success   bool      `json:"Success" xml:"Success"`
	Code      int       `json:"Code" xml:"Code"`
	Msg       string    `json:"Msg" xml:"Msg"`
	Head      Head      `json:"Head" xml:"Head"`
	PicInfo   PicInfo   `json:"PicInfo" xml:"PicInfo"`
	Auctions  []Auction `json:"Auctions" xml:"Auctions"`
}

// CreateSearchImageRequest creates a request to invoke SearchImage API
func CreateSearchImageRequest() (request *SearchImageRequest) {
	request = &SearchImageRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ImageSearch", "2019-03-25", "SearchImage", "/v2/image/search", "imagesearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSearchImageResponse creates a response to parse from SearchImage response
func CreateSearchImageResponse() (response *SearchImageResponse) {
	response = &SearchImageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
