package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSupportFeatures invokes the gpdb.DescribeSupportFeatures API synchronously
func (client *Client) DescribeSupportFeatures(request *DescribeSupportFeaturesRequest) (response *DescribeSupportFeaturesResponse, err error) {
	response = CreateDescribeSupportFeaturesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSupportFeaturesWithChan invokes the gpdb.DescribeSupportFeatures API asynchronously
func (client *Client) DescribeSupportFeaturesWithChan(request *DescribeSupportFeaturesRequest) (<-chan *DescribeSupportFeaturesResponse, <-chan error) {
	responseChan := make(chan *DescribeSupportFeaturesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSupportFeatures(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSupportFeaturesWithCallback invokes the gpdb.DescribeSupportFeatures API asynchronously
func (client *Client) DescribeSupportFeaturesWithCallback(request *DescribeSupportFeaturesRequest, callback func(response *DescribeSupportFeaturesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSupportFeaturesResponse
		var err error
		defer close(result)
		response, err = client.DescribeSupportFeatures(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSupportFeaturesRequest is the request struct for api DescribeSupportFeatures
type DescribeSupportFeaturesRequest struct {
	*requests.RpcRequest
	DBInstanceId string           `position:"Query" name:"DBInstanceId"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeSupportFeaturesResponse is the response struct for api DescribeSupportFeatures
type DescribeSupportFeaturesResponse struct {
	*responses.BaseResponse
	RequestId          string `json:"RequestId" xml:"RequestId"`
	DBInstanceId       string `json:"DBInstanceId" xml:"DBInstanceId"`
	SupportFeatureList string `json:"SupportFeatureList" xml:"SupportFeatureList"`
}

// CreateDescribeSupportFeaturesRequest creates a request to invoke DescribeSupportFeatures API
func CreateDescribeSupportFeaturesRequest() (request *DescribeSupportFeaturesRequest) {
	request = &DescribeSupportFeaturesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "DescribeSupportFeatures", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeSupportFeaturesResponse creates a response to parse from DescribeSupportFeatures response
func CreateDescribeSupportFeaturesResponse() (response *DescribeSupportFeaturesResponse) {
	response = &DescribeSupportFeaturesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
