package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDownloadSQLLogs invokes the gpdb.DescribeDownloadSQLLogs API synchronously
func (client *Client) DescribeDownloadSQLLogs(request *DescribeDownloadSQLLogsRequest) (response *DescribeDownloadSQLLogsResponse, err error) {
	response = CreateDescribeDownloadSQLLogsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDownloadSQLLogsWithChan invokes the gpdb.DescribeDownloadSQLLogs API asynchronously
func (client *Client) DescribeDownloadSQLLogsWithChan(request *DescribeDownloadSQLLogsRequest) (<-chan *DescribeDownloadSQLLogsResponse, <-chan error) {
	responseChan := make(chan *DescribeDownloadSQLLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDownloadSQLLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDownloadSQLLogsWithCallback invokes the gpdb.DescribeDownloadSQLLogs API asynchronously
func (client *Client) DescribeDownloadSQLLogsWithCallback(request *DescribeDownloadSQLLogsRequest, callback func(response *DescribeDownloadSQLLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDownloadSQLLogsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDownloadSQLLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDownloadSQLLogsRequest is the request struct for api DescribeDownloadSQLLogs
type DescribeDownloadSQLLogsRequest struct {
	*requests.RpcRequest
	DBInstanceId string `position:"Query" name:"DBInstanceId"`
}

// DescribeDownloadSQLLogsResponse is the response struct for api DescribeDownloadSQLLogs
type DescribeDownloadSQLLogsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Records   []Item `json:"Records" xml:"Records"`
}

// CreateDescribeDownloadSQLLogsRequest creates a request to invoke DescribeDownloadSQLLogs API
func CreateDescribeDownloadSQLLogsRequest() (request *DescribeDownloadSQLLogsRequest) {
	request = &DescribeDownloadSQLLogsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "DescribeDownloadSQLLogs", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDownloadSQLLogsResponse creates a response to parse from DescribeDownloadSQLLogs response
func CreateDescribeDownloadSQLLogsResponse() (response *DescribeDownloadSQLLogsResponse) {
	response = &DescribeDownloadSQLLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
