package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBInstanceIndexUsage invokes the gpdb.DescribeDBInstanceIndexUsage API synchronously
func (client *Client) DescribeDBInstanceIndexUsage(request *DescribeDBInstanceIndexUsageRequest) (response *DescribeDBInstanceIndexUsageResponse, err error) {
	response = CreateDescribeDBInstanceIndexUsageResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBInstanceIndexUsageWithChan invokes the gpdb.DescribeDBInstanceIndexUsage API asynchronously
func (client *Client) DescribeDBInstanceIndexUsageWithChan(request *DescribeDBInstanceIndexUsageRequest) (<-chan *DescribeDBInstanceIndexUsageResponse, <-chan error) {
	responseChan := make(chan *DescribeDBInstanceIndexUsageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBInstanceIndexUsage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBInstanceIndexUsageWithCallback invokes the gpdb.DescribeDBInstanceIndexUsage API asynchronously
func (client *Client) DescribeDBInstanceIndexUsageWithCallback(request *DescribeDBInstanceIndexUsageRequest, callback func(response *DescribeDBInstanceIndexUsageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBInstanceIndexUsageResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBInstanceIndexUsage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBInstanceIndexUsageRequest is the request struct for api DescribeDBInstanceIndexUsage
type DescribeDBInstanceIndexUsageRequest struct {
	*requests.RpcRequest
	PageNumber   requests.Integer `position:"Query" name:"PageNumber"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	DBInstanceId string           `position:"Query" name:"DBInstanceId"`
}

// DescribeDBInstanceIndexUsageResponse is the response struct for api DescribeDBInstanceIndexUsage
type DescribeDBInstanceIndexUsageResponse struct {
	*responses.BaseResponse
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	TotalCount int         `json:"TotalCount" xml:"TotalCount"`
	PageNumber int         `json:"PageNumber" xml:"PageNumber"`
	Items      []ItemsItem `json:"Items" xml:"Items"`
}

// CreateDescribeDBInstanceIndexUsageRequest creates a request to invoke DescribeDBInstanceIndexUsage API
func CreateDescribeDBInstanceIndexUsageRequest() (request *DescribeDBInstanceIndexUsageRequest) {
	request = &DescribeDBInstanceIndexUsageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "DescribeDBInstanceIndexUsage", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDBInstanceIndexUsageResponse creates a response to parse from DescribeDBInstanceIndexUsage response
func CreateDescribeDBInstanceIndexUsageResponse() (response *DescribeDBInstanceIndexUsageResponse) {
	response = &DescribeDBInstanceIndexUsageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
