package ga

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAccelerator invokes the ga.CreateAccelerator API synchronously
func (client *Client) CreateAccelerator(request *CreateAcceleratorRequest) (response *CreateAcceleratorResponse, err error) {
	response = CreateCreateAcceleratorResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAcceleratorWithChan invokes the ga.CreateAccelerator API asynchronously
func (client *Client) CreateAcceleratorWithChan(request *CreateAcceleratorRequest) (<-chan *CreateAcceleratorResponse, <-chan error) {
	responseChan := make(chan *CreateAcceleratorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAccelerator(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAcceleratorWithCallback invokes the ga.CreateAccelerator API asynchronously
func (client *Client) CreateAcceleratorWithCallback(request *CreateAcceleratorRequest, callback func(response *CreateAcceleratorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAcceleratorResponse
		var err error
		defer close(result)
		response, err = client.CreateAccelerator(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAcceleratorRequest is the request struct for api CreateAccelerator
type CreateAcceleratorRequest struct {
	*requests.RpcRequest
	AutoPay           requests.Boolean `position:"Query" name:"AutoPay"`
	PromotionOptionNo string           `position:"Query" name:"PromotionOptionNo"`
	ClientToken       string           `position:"Query" name:"ClientToken"`
	AutoUseCoupon     string           `position:"Query" name:"AutoUseCoupon"`
	Spec              string           `position:"Query" name:"Spec"`
	Duration          requests.Integer `position:"Query" name:"Duration"`
	Name              string           `position:"Query" name:"Name"`
	PricingCycle      string           `position:"Query" name:"PricingCycle"`
}

// CreateAcceleratorResponse is the response struct for api CreateAccelerator
type CreateAcceleratorResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	OrderId       string `json:"OrderId" xml:"OrderId"`
	AcceleratorId string `json:"AcceleratorId" xml:"AcceleratorId"`
}

// CreateCreateAcceleratorRequest creates a request to invoke CreateAccelerator API
func CreateCreateAcceleratorRequest() (request *CreateAcceleratorRequest) {
	request = &CreateAcceleratorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ga", "2019-11-20", "CreateAccelerator", "gaplus", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateAcceleratorResponse creates a response to parse from CreateAccelerator response
func CreateCreateAcceleratorResponse() (response *CreateAcceleratorResponse) {
	response = &CreateAcceleratorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
