package eventbridge

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryEvent invokes the eventbridge.QueryEvent API synchronously
func (client *Client) QueryEvent(request *QueryEventRequest) (response *QueryEventResponse, err error) {
	response = CreateQueryEventResponse()
	err = client.DoAction(request, response)
	return
}

// QueryEventWithChan invokes the eventbridge.QueryEvent API asynchronously
func (client *Client) QueryEventWithChan(request *QueryEventRequest) (<-chan *QueryEventResponse, <-chan error) {
	responseChan := make(chan *QueryEventResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryEvent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryEventWithCallback invokes the eventbridge.QueryEvent API asynchronously
func (client *Client) QueryEventWithCallback(request *QueryEventRequest, callback func(response *QueryEventResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryEventResponse
		var err error
		defer close(result)
		response, err = client.QueryEvent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryEventRequest is the request struct for api QueryEvent
type QueryEventRequest struct {
	*requests.RpcRequest
	EventId      string `position:"Query" name:"EventId"`
	EventBusName string `position:"Query" name:"EventBusName"`
	EventSource  string `position:"Query" name:"EventSource"`
}

// QueryEventResponse is the response struct for api QueryEvent
type QueryEventResponse struct {
	*responses.BaseResponse
	Message   string                 `json:"Message" xml:"Message"`
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Data      map[string]interface{} `json:"Data" xml:"Data"`
	Code      string                 `json:"Code" xml:"Code"`
	Success   bool                   `json:"Success" xml:"Success"`
}

// CreateQueryEventRequest creates a request to invoke QueryEvent API
func CreateQueryEventRequest() (request *QueryEventRequest) {
	request = &QueryEventRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eventbridge", "2020-04-01", "QueryEvent", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryEventResponse creates a response to parse from QueryEvent response
func CreateQueryEventResponse() (response *QueryEventResponse) {
	response = &QueryEventResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
