package ess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetInstanceHealth invokes the ess.SetInstanceHealth API synchronously
func (client *Client) SetInstanceHealth(request *SetInstanceHealthRequest) (response *SetInstanceHealthResponse, err error) {
	response = CreateSetInstanceHealthResponse()
	err = client.DoAction(request, response)
	return
}

// SetInstanceHealthWithChan invokes the ess.SetInstanceHealth API asynchronously
func (client *Client) SetInstanceHealthWithChan(request *SetInstanceHealthRequest) (<-chan *SetInstanceHealthResponse, <-chan error) {
	responseChan := make(chan *SetInstanceHealthResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetInstanceHealth(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetInstanceHealthWithCallback invokes the ess.SetInstanceHealth API asynchronously
func (client *Client) SetInstanceHealthWithCallback(request *SetInstanceHealthRequest, callback func(response *SetInstanceHealthResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetInstanceHealthResponse
		var err error
		defer close(result)
		response, err = client.SetInstanceHealth(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetInstanceHealthRequest is the request struct for api SetInstanceHealth
type SetInstanceHealthRequest struct {
	*requests.RpcRequest
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	HealthStatus         string           `position:"Query" name:"HealthStatus"`
}

// SetInstanceHealthResponse is the response struct for api SetInstanceHealth
type SetInstanceHealthResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetInstanceHealthRequest creates a request to invoke SetInstanceHealth API
func CreateSetInstanceHealthRequest() (request *SetInstanceHealthRequest) {
	request = &SetInstanceHealthRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ess", "2014-08-28", "SetInstanceHealth", "ess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetInstanceHealthResponse creates a response to parse from SetInstanceHealth response
func CreateSetInstanceHealthResponse() (response *SetInstanceHealthResponse) {
	response = &SetInstanceHealthResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
