package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeploySDG invokes the ens.DeploySDG API synchronously
func (client *Client) DeploySDG(request *DeploySDGRequest) (response *DeploySDGResponse, err error) {
	response = CreateDeploySDGResponse()
	err = client.DoAction(request, response)
	return
}

// DeploySDGWithChan invokes the ens.DeploySDG API asynchronously
func (client *Client) DeploySDGWithChan(request *DeploySDGRequest) (<-chan *DeploySDGResponse, <-chan error) {
	responseChan := make(chan *DeploySDGResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeploySDG(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeploySDGWithCallback invokes the ens.DeploySDG API asynchronously
func (client *Client) DeploySDGWithCallback(request *DeploySDGRequest, callback func(response *DeploySDGResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeploySDGResponse
		var err error
		defer close(result)
		response, err = client.DeploySDG(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeploySDGRequest is the request struct for api DeploySDG
type DeploySDGRequest struct {
	*requests.RpcRequest
	DeploymentType string    `position:"Query" name:"DeploymentType"`
	SDGId          string    `position:"Query" name:"SDGId"`
	InstanceIds    *[]string `position:"Query" name:"InstanceIds"  type:"Json"`
}

// DeploySDGResponse is the response struct for api DeploySDG
type DeploySDGResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDeploySDGRequest creates a request to invoke DeploySDG API
func CreateDeploySDGRequest() (request *DeploySDGRequest) {
	request = &DeploySDGRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DeploySDG", "ens", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDeploySDGResponse creates a response to parse from DeploySDG response
func CreateDeploySDGResponse() (response *DeploySDGResponse) {
	response = &DeploySDGResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
