package emas_appmonitor

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySingleDomainApiErrorGroupTrend invokes the emas_appmonitor.QuerySingleDomainApiErrorGroupTrend API synchronously
func (client *Client) QuerySingleDomainApiErrorGroupTrend(request *QuerySingleDomainApiErrorGroupTrendRequest) (response *QuerySingleDomainApiErrorGroupTrendResponse, err error) {
	response = CreateQuerySingleDomainApiErrorGroupTrendResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySingleDomainApiErrorGroupTrendWithChan invokes the emas_appmonitor.QuerySingleDomainApiErrorGroupTrend API asynchronously
func (client *Client) QuerySingleDomainApiErrorGroupTrendWithChan(request *QuerySingleDomainApiErrorGroupTrendRequest) (<-chan *QuerySingleDomainApiErrorGroupTrendResponse, <-chan error) {
	responseChan := make(chan *QuerySingleDomainApiErrorGroupTrendResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySingleDomainApiErrorGroupTrend(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySingleDomainApiErrorGroupTrendWithCallback invokes the emas_appmonitor.QuerySingleDomainApiErrorGroupTrend API asynchronously
func (client *Client) QuerySingleDomainApiErrorGroupTrendWithCallback(request *QuerySingleDomainApiErrorGroupTrendRequest, callback func(response *QuerySingleDomainApiErrorGroupTrendResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySingleDomainApiErrorGroupTrendResponse
		var err error
		defer close(result)
		response, err = client.QuerySingleDomainApiErrorGroupTrend(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySingleDomainApiErrorGroupTrendRequest is the request struct for api QuerySingleDomainApiErrorGroupTrend
type QuerySingleDomainApiErrorGroupTrendRequest struct {
	*requests.RpcRequest
	AppVersionStrategy string           `position:"Body" name:"AppVersionStrategy"`
	StartTime          requests.Integer `position:"Body" name:"StartTime"`
	Group              string           `position:"Body" name:"Group"`
	IntervalMinutes    requests.Integer `position:"Body" name:"IntervalMinutes"`
	UniqueAppId        string           `position:"Body" name:"UniqueAppId"`
	EndTime            requests.Integer `position:"Body" name:"EndTime"`
	AppVersion         *[]string        `position:"Body" name:"AppVersion"  type:"Repeated"`
	Domain             string           `position:"Body" name:"Domain"`
}

// QuerySingleDomainApiErrorGroupTrendResponse is the response struct for api QuerySingleDomainApiErrorGroupTrend
type QuerySingleDomainApiErrorGroupTrendResponse struct {
	*responses.BaseResponse
	RequestId        string             `json:"RequestId" xml:"RequestId"`
	MetricResultList []MetricResultItem `json:"MetricResultList" xml:"MetricResultList"`
}

// CreateQuerySingleDomainApiErrorGroupTrendRequest creates a request to invoke QuerySingleDomainApiErrorGroupTrend API
func CreateQuerySingleDomainApiErrorGroupTrendRequest() (request *QuerySingleDomainApiErrorGroupTrendRequest) {
	request = &QuerySingleDomainApiErrorGroupTrendRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("emas-appmonitor", "2019-06-11", "QuerySingleDomainApiErrorGroupTrend", "", "")
	request.Method = requests.POST
	return
}

// CreateQuerySingleDomainApiErrorGroupTrendResponse creates a response to parse from QuerySingleDomainApiErrorGroupTrend response
func CreateQuerySingleDomainApiErrorGroupTrendResponse() (response *QuerySingleDomainApiErrorGroupTrendResponse) {
	response = &QuerySingleDomainApiErrorGroupTrendResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
