package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ValidateConnection invokes the elasticsearch.ValidateConnection API synchronously
func (client *Client) ValidateConnection(request *ValidateConnectionRequest) (response *ValidateConnectionResponse, err error) {
	response = CreateValidateConnectionResponse()
	err = client.DoAction(request, response)
	return
}

// ValidateConnectionWithChan invokes the elasticsearch.ValidateConnection API asynchronously
func (client *Client) ValidateConnectionWithChan(request *ValidateConnectionRequest) (<-chan *ValidateConnectionResponse, <-chan error) {
	responseChan := make(chan *ValidateConnectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ValidateConnection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ValidateConnectionWithCallback invokes the elasticsearch.ValidateConnection API asynchronously
func (client *Client) ValidateConnectionWithCallback(request *ValidateConnectionRequest, callback func(response *ValidateConnectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ValidateConnectionResponse
		var err error
		defer close(result)
		response, err = client.ValidateConnection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ValidateConnectionRequest is the request struct for api ValidateConnection
type ValidateConnectionRequest struct {
	*requests.RoaRequest
	InstanceId  string `position:"Path" name:"InstanceId"`
	ClientToken string `position:"Query" name:"ClientToken"`
	Body        string `position:"Body" name:"body"`
}

// ValidateConnectionResponse is the response struct for api ValidateConnection
type ValidateConnectionResponse struct {
	*responses.BaseResponse
	Result    bool   `json:"Result" xml:"Result"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateValidateConnectionRequest creates a request to invoke ValidateConnection API
func CreateValidateConnectionRequest() (request *ValidateConnectionRequest) {
	request = &ValidateConnectionRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "ValidateConnection", "/openapi/logstashes/[InstanceId]/validate-connection", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateValidateConnectionResponse creates a response to parse from ValidateConnection response
func CreateValidateConnectionResponse() (response *ValidateConnectionResponse) {
	response = &ValidateConnectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
