package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartApm invokes the elasticsearch.StartApm API synchronously
func (client *Client) StartApm(request *StartApmRequest) (response *StartApmResponse, err error) {
	response = CreateStartApmResponse()
	err = client.DoAction(request, response)
	return
}

// StartApmWithChan invokes the elasticsearch.StartApm API asynchronously
func (client *Client) StartApmWithChan(request *StartApmRequest) (<-chan *StartApmResponse, <-chan error) {
	responseChan := make(chan *StartApmResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartApm(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartApmWithCallback invokes the elasticsearch.StartApm API asynchronously
func (client *Client) StartApmWithCallback(request *StartApmRequest, callback func(response *StartApmResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartApmResponse
		var err error
		defer close(result)
		response, err = client.StartApm(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartApmRequest is the request struct for api StartApm
type StartApmRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"instanceId"`
}

// StartApmResponse is the response struct for api StartApm
type StartApmResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateStartApmRequest creates a request to invoke StartApm API
func CreateStartApmRequest() (request *StartApmRequest) {
	request = &StartApmRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "StartApm", "/openapi/apm/[instanceId]/actions/start", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStartApmResponse creates a response to parse from StartApm response
func CreateStartApmResponse() (response *StartApmResponse) {
	response = &StartApmResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
