package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListIndexTemplates invokes the elasticsearch.ListIndexTemplates API synchronously
func (client *Client) ListIndexTemplates(request *ListIndexTemplatesRequest) (response *ListIndexTemplatesResponse, err error) {
	response = CreateListIndexTemplatesResponse()
	err = client.DoAction(request, response)
	return
}

// ListIndexTemplatesWithChan invokes the elasticsearch.ListIndexTemplates API asynchronously
func (client *Client) ListIndexTemplatesWithChan(request *ListIndexTemplatesRequest) (<-chan *ListIndexTemplatesResponse, <-chan error) {
	responseChan := make(chan *ListIndexTemplatesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListIndexTemplates(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListIndexTemplatesWithCallback invokes the elasticsearch.ListIndexTemplates API asynchronously
func (client *Client) ListIndexTemplatesWithCallback(request *ListIndexTemplatesRequest, callback func(response *ListIndexTemplatesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListIndexTemplatesResponse
		var err error
		defer close(result)
		response, err = client.ListIndexTemplates(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListIndexTemplatesRequest is the request struct for api ListIndexTemplates
type ListIndexTemplatesRequest struct {
	*requests.RoaRequest
	InstanceId    string           `position:"Path" name:"InstanceId"`
	Size          requests.Integer `position:"Query" name:"size"`
	Page          requests.Integer `position:"Query" name:"page"`
	IndexTemplate string           `position:"Query" name:"indexTemplate"`
}

// ListIndexTemplatesResponse is the response struct for api ListIndexTemplates
type ListIndexTemplatesResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateListIndexTemplatesRequest creates a request to invoke ListIndexTemplates API
func CreateListIndexTemplatesRequest() (request *ListIndexTemplatesRequest) {
	request = &ListIndexTemplatesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "ListIndexTemplates", "/openapi/instances/[InstanceId]/index-templates", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListIndexTemplatesResponse creates a response to parse from ListIndexTemplates response
func CreateListIndexTemplatesResponse() (response *ListIndexTemplatesResponse) {
	response = &ListIndexTemplatesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
