package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFilePermission invokes the ecd.ListFilePermission API synchronously
func (client *Client) ListFilePermission(request *ListFilePermissionRequest) (response *ListFilePermissionResponse, err error) {
	response = CreateListFilePermissionResponse()
	err = client.DoAction(request, response)
	return
}

// ListFilePermissionWithChan invokes the ecd.ListFilePermission API asynchronously
func (client *Client) ListFilePermissionWithChan(request *ListFilePermissionRequest) (<-chan *ListFilePermissionResponse, <-chan error) {
	responseChan := make(chan *ListFilePermissionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFilePermission(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFilePermissionWithCallback invokes the ecd.ListFilePermission API asynchronously
func (client *Client) ListFilePermissionWithCallback(request *ListFilePermissionRequest, callback func(response *ListFilePermissionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFilePermissionResponse
		var err error
		defer close(result)
		response, err = client.ListFilePermission(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFilePermissionRequest is the request struct for api ListFilePermission
type ListFilePermissionRequest struct {
	*requests.RpcRequest
	GroupId   string `position:"Query" name:"GroupId"`
	CdsId     string `position:"Query" name:"CdsId"`
	EndUserId string `position:"Query" name:"EndUserId"`
	FileId    string `position:"Query" name:"FileId"`
}

// ListFilePermissionResponse is the response struct for api ListFilePermission
type ListFilePermissionResponse struct {
	*responses.BaseResponse
	RequestId       string           `json:"RequestId" xml:"RequestId"`
	FilePermissions []FilePermission `json:"FilePermissions" xml:"FilePermissions"`
}

// CreateListFilePermissionRequest creates a request to invoke ListFilePermission API
func CreateListFilePermissionRequest() (request *ListFilePermissionRequest) {
	request = &ListFilePermissionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ListFilePermission", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListFilePermissionResponse creates a response to parse from ListFilePermission response
func CreateListFilePermissionResponse() (response *ListFilePermissionResponse) {
	response = &ListFilePermissionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
