package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddUserToDesktopOversoldUserGroup invokes the ecd.AddUserToDesktopOversoldUserGroup API synchronously
func (client *Client) AddUserToDesktopOversoldUserGroup(request *AddUserToDesktopOversoldUserGroupRequest) (response *AddUserToDesktopOversoldUserGroupResponse, err error) {
	response = CreateAddUserToDesktopOversoldUserGroupResponse()
	err = client.DoAction(request, response)
	return
}

// AddUserToDesktopOversoldUserGroupWithChan invokes the ecd.AddUserToDesktopOversoldUserGroup API asynchronously
func (client *Client) AddUserToDesktopOversoldUserGroupWithChan(request *AddUserToDesktopOversoldUserGroupRequest) (<-chan *AddUserToDesktopOversoldUserGroupResponse, <-chan error) {
	responseChan := make(chan *AddUserToDesktopOversoldUserGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddUserToDesktopOversoldUserGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddUserToDesktopOversoldUserGroupWithCallback invokes the ecd.AddUserToDesktopOversoldUserGroup API asynchronously
func (client *Client) AddUserToDesktopOversoldUserGroupWithCallback(request *AddUserToDesktopOversoldUserGroupRequest, callback func(response *AddUserToDesktopOversoldUserGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddUserToDesktopOversoldUserGroupResponse
		var err error
		defer close(result)
		response, err = client.AddUserToDesktopOversoldUserGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddUserToDesktopOversoldUserGroupRequest is the request struct for api AddUserToDesktopOversoldUserGroup
type AddUserToDesktopOversoldUserGroupRequest struct {
	*requests.RpcRequest
	AddUserAmount   requests.Integer `position:"Query" name:"AddUserAmount"`
	OversoldGroupId string           `position:"Query" name:"OversoldGroupId"`
	UserGroupId     string           `position:"Query" name:"UserGroupId"`
	EndUserId       string           `position:"Query" name:"EndUserId"`
}

// AddUserToDesktopOversoldUserGroupResponse is the response struct for api AddUserToDesktopOversoldUserGroup
type AddUserToDesktopOversoldUserGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddUserToDesktopOversoldUserGroupRequest creates a request to invoke AddUserToDesktopOversoldUserGroup API
func CreateAddUserToDesktopOversoldUserGroupRequest() (request *AddUserToDesktopOversoldUserGroupRequest) {
	request = &AddUserToDesktopOversoldUserGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "AddUserToDesktopOversoldUserGroup", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddUserToDesktopOversoldUserGroupResponse creates a response to parse from AddUserToDesktopOversoldUserGroup response
func CreateAddUserToDesktopOversoldUserGroupResponse() (response *AddUserToDesktopOversoldUserGroupResponse) {
	response = &AddUserToDesktopOversoldUserGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
