package eas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteServiceInstances invokes the eas.DeleteServiceInstances API synchronously
func (client *Client) DeleteServiceInstances(request *DeleteServiceInstancesRequest) (response *DeleteServiceInstancesResponse, err error) {
	response = CreateDeleteServiceInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteServiceInstancesWithChan invokes the eas.DeleteServiceInstances API asynchronously
func (client *Client) DeleteServiceInstancesWithChan(request *DeleteServiceInstancesRequest) (<-chan *DeleteServiceInstancesResponse, <-chan error) {
	responseChan := make(chan *DeleteServiceInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteServiceInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteServiceInstancesWithCallback invokes the eas.DeleteServiceInstances API asynchronously
func (client *Client) DeleteServiceInstancesWithCallback(request *DeleteServiceInstancesRequest, callback func(response *DeleteServiceInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteServiceInstancesResponse
		var err error
		defer close(result)
		response, err = client.DeleteServiceInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteServiceInstancesRequest is the request struct for api DeleteServiceInstances
type DeleteServiceInstancesRequest struct {
	*requests.RoaRequest
	InstanceList string `position:"Query" name:"InstanceList"`
	ServiceName  string `position:"Path" name:"ServiceName"`
	ClusterId    string `position:"Path" name:"ClusterId"`
}

// DeleteServiceInstancesResponse is the response struct for api DeleteServiceInstances
type DeleteServiceInstancesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateDeleteServiceInstancesRequest creates a request to invoke DeleteServiceInstances API
func CreateDeleteServiceInstancesRequest() (request *DeleteServiceInstancesRequest) {
	request = &DeleteServiceInstancesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("eas", "2021-07-01", "DeleteServiceInstances", "/api/v2/services/[ClusterId]/[ServiceName]/instances", "eas", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateDeleteServiceInstancesResponse creates a response to parse from DeleteServiceInstances response
func CreateDeleteServiceInstancesResponse() (response *DeleteServiceInstancesResponse) {
	response = &DeleteServiceInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
