package dt_oc_info

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOcIcChangeRecord invokes the dt_oc_info.GetOcIcChangeRecord API synchronously
func (client *Client) GetOcIcChangeRecord(request *GetOcIcChangeRecordRequest) (response *GetOcIcChangeRecordResponse, err error) {
	response = CreateGetOcIcChangeRecordResponse()
	err = client.DoAction(request, response)
	return
}

// GetOcIcChangeRecordWithChan invokes the dt_oc_info.GetOcIcChangeRecord API asynchronously
func (client *Client) GetOcIcChangeRecordWithChan(request *GetOcIcChangeRecordRequest) (<-chan *GetOcIcChangeRecordResponse, <-chan error) {
	responseChan := make(chan *GetOcIcChangeRecordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOcIcChangeRecord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOcIcChangeRecordWithCallback invokes the dt_oc_info.GetOcIcChangeRecord API asynchronously
func (client *Client) GetOcIcChangeRecordWithCallback(request *GetOcIcChangeRecordRequest, callback func(response *GetOcIcChangeRecordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOcIcChangeRecordResponse
		var err error
		defer close(result)
		response, err = client.GetOcIcChangeRecord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOcIcChangeRecordRequest is the request struct for api GetOcIcChangeRecord
type GetOcIcChangeRecordRequest struct {
	*requests.RpcRequest
	PageNo    requests.Integer `position:"Body" name:"PageNo"`
	PageSize  requests.Integer `position:"Body" name:"PageSize"`
	SearchKey string           `position:"Body" name:"SearchKey"`
}

// GetOcIcChangeRecordResponse is the response struct for api GetOcIcChangeRecord
type GetOcIcChangeRecordResponse struct {
	*responses.BaseResponse
	Code      string     `json:"Code" xml:"Code"`
	Success   bool       `json:"Success" xml:"Success"`
	Message   string     `json:"Message" xml:"Message"`
	TotalNum  int        `json:"TotalNum" xml:"TotalNum"`
	PageIndex int        `json:"PageIndex" xml:"PageIndex"`
	PageNum   int        `json:"PageNum" xml:"PageNum"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateGetOcIcChangeRecordRequest creates a request to invoke GetOcIcChangeRecord API
func CreateGetOcIcChangeRecordRequest() (request *GetOcIcChangeRecordRequest) {
	request = &GetOcIcChangeRecordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dt-oc-info", "2022-08-29", "GetOcIcChangeRecord", "", "")
	request.Method = requests.POST
	return
}

// CreateGetOcIcChangeRecordResponse creates a response to parse from GetOcIcChangeRecord response
func CreateGetOcIcChangeRecordResponse() (response *GetOcIcChangeRecordResponse) {
	response = &GetOcIcChangeRecordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
