package dfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetFileSystem invokes the dfs.GetFileSystem API synchronously
func (client *Client) GetFileSystem(request *GetFileSystemRequest) (response *GetFileSystemResponse, err error) {
	response = CreateGetFileSystemResponse()
	err = client.DoAction(request, response)
	return
}

// GetFileSystemWithChan invokes the dfs.GetFileSystem API asynchronously
func (client *Client) GetFileSystemWithChan(request *GetFileSystemRequest) (<-chan *GetFileSystemResponse, <-chan error) {
	responseChan := make(chan *GetFileSystemResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetFileSystem(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetFileSystemWithCallback invokes the dfs.GetFileSystem API asynchronously
func (client *Client) GetFileSystemWithCallback(request *GetFileSystemRequest, callback func(response *GetFileSystemResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetFileSystemResponse
		var err error
		defer close(result)
		response, err = client.GetFileSystem(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetFileSystemRequest is the request struct for api GetFileSystem
type GetFileSystemRequest struct {
	*requests.RpcRequest
	InputRegionId string `position:"Query" name:"InputRegionId"`
	FileSystemId  string `position:"Query" name:"FileSystemId"`
}

// GetFileSystemResponse is the response struct for api GetFileSystem
type GetFileSystemResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	FileSystem FileSystem `json:"FileSystem" xml:"FileSystem"`
}

// CreateGetFileSystemRequest creates a request to invoke GetFileSystem API
func CreateGetFileSystemRequest() (request *GetFileSystemRequest) {
	request = &GetFileSystemRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DFS", "2018-06-20", "GetFileSystem", "alidfs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetFileSystemResponse creates a response to parse from GetFileSystem response
func CreateGetFileSystemResponse() (response *GetFileSystemResponse) {
	response = &GetFileSystemResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
