package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnWafDefaultRules invokes the dcdn.DescribeDcdnWafDefaultRules API synchronously
func (client *Client) DescribeDcdnWafDefaultRules(request *DescribeDcdnWafDefaultRulesRequest) (response *DescribeDcdnWafDefaultRulesResponse, err error) {
	response = CreateDescribeDcdnWafDefaultRulesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnWafDefaultRulesWithChan invokes the dcdn.DescribeDcdnWafDefaultRules API asynchronously
func (client *Client) DescribeDcdnWafDefaultRulesWithChan(request *DescribeDcdnWafDefaultRulesRequest) (<-chan *DescribeDcdnWafDefaultRulesResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnWafDefaultRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnWafDefaultRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnWafDefaultRulesWithCallback invokes the dcdn.DescribeDcdnWafDefaultRules API asynchronously
func (client *Client) DescribeDcdnWafDefaultRulesWithCallback(request *DescribeDcdnWafDefaultRulesRequest, callback func(response *DescribeDcdnWafDefaultRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnWafDefaultRulesResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnWafDefaultRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnWafDefaultRulesRequest is the request struct for api DescribeDcdnWafDefaultRules
type DescribeDcdnWafDefaultRulesRequest struct {
	*requests.RpcRequest
	QueryArgs string `position:"Query" name:"QueryArgs"`
}

// DescribeDcdnWafDefaultRulesResponse is the response struct for api DescribeDcdnWafDefaultRules
type DescribeDcdnWafDefaultRulesResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Content   []Default `json:"Content" xml:"Content"`
}

// CreateDescribeDcdnWafDefaultRulesRequest creates a request to invoke DescribeDcdnWafDefaultRules API
func CreateDescribeDcdnWafDefaultRulesRequest() (request *DescribeDcdnWafDefaultRulesRequest) {
	request = &DescribeDcdnWafDefaultRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnWafDefaultRules", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnWafDefaultRulesResponse creates a response to parse from DescribeDcdnWafDefaultRules response
func CreateDescribeDcdnWafDefaultRulesResponse() (response *DescribeDcdnWafDefaultRulesResponse) {
	response = &DescribeDcdnWafDefaultRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
