package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnL2Ips invokes the dcdn.DescribeDcdnL2Ips API synchronously
func (client *Client) DescribeDcdnL2Ips(request *DescribeDcdnL2IpsRequest) (response *DescribeDcdnL2IpsResponse, err error) {
	response = CreateDescribeDcdnL2IpsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnL2IpsWithChan invokes the dcdn.DescribeDcdnL2Ips API asynchronously
func (client *Client) DescribeDcdnL2IpsWithChan(request *DescribeDcdnL2IpsRequest) (<-chan *DescribeDcdnL2IpsResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnL2IpsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnL2Ips(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnL2IpsWithCallback invokes the dcdn.DescribeDcdnL2Ips API asynchronously
func (client *Client) DescribeDcdnL2IpsWithCallback(request *DescribeDcdnL2IpsRequest, callback func(response *DescribeDcdnL2IpsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnL2IpsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnL2Ips(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnL2IpsRequest is the request struct for api DescribeDcdnL2Ips
type DescribeDcdnL2IpsRequest struct {
	*requests.RpcRequest
}

// DescribeDcdnL2IpsResponse is the response struct for api DescribeDcdnL2Ips
type DescribeDcdnL2IpsResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Vips      []string `json:"Vips" xml:"Vips"`
}

// CreateDescribeDcdnL2IpsRequest creates a request to invoke DescribeDcdnL2Ips API
func CreateDescribeDcdnL2IpsRequest() (request *DescribeDcdnL2IpsRequest) {
	request = &DescribeDcdnL2IpsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnL2Ips", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeDcdnL2IpsResponse creates a response to parse from DescribeDcdnL2Ips response
func CreateDescribeDcdnL2IpsResponse() (response *DescribeDcdnL2IpsResponse) {
	response = &DescribeDcdnL2IpsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
