package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDcdnWafGroup invokes the dcdn.DeleteDcdnWafGroup API synchronously
func (client *Client) DeleteDcdnWafGroup(request *DeleteDcdnWafGroupRequest) (response *DeleteDcdnWafGroupResponse, err error) {
	response = CreateDeleteDcdnWafGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDcdnWafGroupWithChan invokes the dcdn.DeleteDcdnWafGroup API asynchronously
func (client *Client) DeleteDcdnWafGroupWithChan(request *DeleteDcdnWafGroupRequest) (<-chan *DeleteDcdnWafGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteDcdnWafGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDcdnWafGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDcdnWafGroupWithCallback invokes the dcdn.DeleteDcdnWafGroup API asynchronously
func (client *Client) DeleteDcdnWafGroupWithCallback(request *DeleteDcdnWafGroupRequest, callback func(response *DeleteDcdnWafGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDcdnWafGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteDcdnWafGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDcdnWafGroupRequest is the request struct for api DeleteDcdnWafGroup
type DeleteDcdnWafGroupRequest struct {
	*requests.RpcRequest
	Id requests.Integer `position:"Body" name:"Id"`
}

// DeleteDcdnWafGroupResponse is the response struct for api DeleteDcdnWafGroup
type DeleteDcdnWafGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDcdnWafGroupRequest creates a request to invoke DeleteDcdnWafGroup API
func CreateDeleteDcdnWafGroupRequest() (request *DeleteDcdnWafGroupRequest) {
	request = &DeleteDcdnWafGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DeleteDcdnWafGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteDcdnWafGroupResponse creates a response to parse from DeleteDcdnWafGroup response
func CreateDeleteDcdnWafGroupResponse() (response *DeleteDcdnWafGroupResponse) {
	response = &DeleteDcdnWafGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
