package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchPutDcdnKv invokes the dcdn.BatchPutDcdnKv API synchronously
func (client *Client) BatchPutDcdnKv(request *BatchPutDcdnKvRequest) (response *BatchPutDcdnKvResponse, err error) {
	response = CreateBatchPutDcdnKvResponse()
	err = client.DoAction(request, response)
	return
}

// BatchPutDcdnKvWithChan invokes the dcdn.BatchPutDcdnKv API asynchronously
func (client *Client) BatchPutDcdnKvWithChan(request *BatchPutDcdnKvRequest) (<-chan *BatchPutDcdnKvResponse, <-chan error) {
	responseChan := make(chan *BatchPutDcdnKvResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchPutDcdnKv(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchPutDcdnKvWithCallback invokes the dcdn.BatchPutDcdnKv API asynchronously
func (client *Client) BatchPutDcdnKvWithCallback(request *BatchPutDcdnKvRequest, callback func(response *BatchPutDcdnKvResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchPutDcdnKvResponse
		var err error
		defer close(result)
		response, err = client.BatchPutDcdnKv(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchPutDcdnKvRequest is the request struct for api BatchPutDcdnKv
type BatchPutDcdnKvRequest struct {
	*requests.RpcRequest
	KvList    *[]BatchPutDcdnKvKvList `position:"Body" name:"KvList"  type:"Json"`
	Namespace string                  `position:"Query" name:"Namespace"`
}

// BatchPutDcdnKvKvList is a repeated param struct in BatchPutDcdnKvRequest
type BatchPutDcdnKvKvList struct {
	Key           string `name:"Key"`
	Value         string `name:"Value"`
	Expiration    string `name:"Expiration"`
	ExpirationTtl string `name:"ExpirationTtl"`
}

// BatchPutDcdnKvResponse is the response struct for api BatchPutDcdnKv
type BatchPutDcdnKvResponse struct {
	*responses.BaseResponse
	RequestId   string   `json:"RequestId" xml:"RequestId"`
	FailKeys    []string `json:"FailKeys" xml:"FailKeys"`
	SuccessKeys []string `json:"SuccessKeys" xml:"SuccessKeys"`
}

// CreateBatchPutDcdnKvRequest creates a request to invoke BatchPutDcdnKv API
func CreateBatchPutDcdnKvRequest() (request *BatchPutDcdnKvRequest) {
	request = &BatchPutDcdnKvRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "BatchPutDcdnKv", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchPutDcdnKvResponse creates a response to parse from BatchPutDcdnKv response
func CreateBatchPutDcdnKvResponse() (response *BatchPutDcdnKvResponse) {
	response = &BatchPutDcdnKvResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
