package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchAddDcdnDomain invokes the dcdn.BatchAddDcdnDomain API synchronously
func (client *Client) BatchAddDcdnDomain(request *BatchAddDcdnDomainRequest) (response *BatchAddDcdnDomainResponse, err error) {
	response = CreateBatchAddDcdnDomainResponse()
	err = client.DoAction(request, response)
	return
}

// BatchAddDcdnDomainWithChan invokes the dcdn.BatchAddDcdnDomain API asynchronously
func (client *Client) BatchAddDcdnDomainWithChan(request *BatchAddDcdnDomainRequest) (<-chan *BatchAddDcdnDomainResponse, <-chan error) {
	responseChan := make(chan *BatchAddDcdnDomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchAddDcdnDomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchAddDcdnDomainWithCallback invokes the dcdn.BatchAddDcdnDomain API asynchronously
func (client *Client) BatchAddDcdnDomainWithCallback(request *BatchAddDcdnDomainRequest, callback func(response *BatchAddDcdnDomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchAddDcdnDomainResponse
		var err error
		defer close(result)
		response, err = client.BatchAddDcdnDomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchAddDcdnDomainRequest is the request struct for api BatchAddDcdnDomain
type BatchAddDcdnDomainRequest struct {
	*requests.RpcRequest
	Sources         string           `position:"Query" name:"Sources"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SecurityToken   string           `position:"Query" name:"SecurityToken"`
	Scope           string           `position:"Query" name:"Scope"`
	TopLevelDomain  string           `position:"Query" name:"TopLevelDomain"`
	OwnerAccount    string           `position:"Query" name:"OwnerAccount"`
	DomainName      string           `position:"Query" name:"DomainName"`
	OwnerId         requests.Integer `position:"Query" name:"OwnerId"`
	CheckUrl        string           `position:"Query" name:"CheckUrl"`
}

// BatchAddDcdnDomainResponse is the response struct for api BatchAddDcdnDomain
type BatchAddDcdnDomainResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateBatchAddDcdnDomainRequest creates a request to invoke BatchAddDcdnDomain API
func CreateBatchAddDcdnDomainRequest() (request *BatchAddDcdnDomainRequest) {
	request = &BatchAddDcdnDomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "BatchAddDcdnDomain", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchAddDcdnDomainResponse creates a response to parse from BatchAddDcdnDomain response
func CreateBatchAddDcdnDomainResponse() (response *BatchAddDcdnDomainResponse) {
	response = &BatchAddDcdnDomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
