package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MountDirectory invokes the dataworks_public.MountDirectory API synchronously
func (client *Client) MountDirectory(request *MountDirectoryRequest) (response *MountDirectoryResponse, err error) {
	response = CreateMountDirectoryResponse()
	err = client.DoAction(request, response)
	return
}

// MountDirectoryWithChan invokes the dataworks_public.MountDirectory API asynchronously
func (client *Client) MountDirectoryWithChan(request *MountDirectoryRequest) (<-chan *MountDirectoryResponse, <-chan error) {
	responseChan := make(chan *MountDirectoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MountDirectory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MountDirectoryWithCallback invokes the dataworks_public.MountDirectory API asynchronously
func (client *Client) MountDirectoryWithCallback(request *MountDirectoryRequest, callback func(response *MountDirectoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MountDirectoryResponse
		var err error
		defer close(result)
		response, err = client.MountDirectory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MountDirectoryRequest is the request struct for api MountDirectory
type MountDirectoryRequest struct {
	*requests.RpcRequest
	TargetType   string `position:"Body" name:"TargetType"`
	TargetId     string `position:"Body" name:"TargetId"`
	TargetUserId string `position:"Body" name:"TargetUserId"`
}

// MountDirectoryResponse is the response struct for api MountDirectory
type MountDirectoryResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           int    `json:"Data" xml:"Data"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateMountDirectoryRequest creates a request to invoke MountDirectory API
func CreateMountDirectoryRequest() (request *MountDirectoryRequest) {
	request = &MountDirectoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "MountDirectory", "", "")
	request.Method = requests.POST
	return
}

// CreateMountDirectoryResponse creates a response to parse from MountDirectory response
func CreateMountDirectoryResponse() (response *MountDirectoryResponse) {
	response = &MountDirectoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
