package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAutoThrottleRules invokes the das.GetAutoThrottleRules API synchronously
func (client *Client) GetAutoThrottleRules(request *GetAutoThrottleRulesRequest) (response *GetAutoThrottleRulesResponse, err error) {
	response = CreateGetAutoThrottleRulesResponse()
	err = client.DoAction(request, response)
	return
}

// GetAutoThrottleRulesWithChan invokes the das.GetAutoThrottleRules API asynchronously
func (client *Client) GetAutoThrottleRulesWithChan(request *GetAutoThrottleRulesRequest) (<-chan *GetAutoThrottleRulesResponse, <-chan error) {
	responseChan := make(chan *GetAutoThrottleRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAutoThrottleRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAutoThrottleRulesWithCallback invokes the das.GetAutoThrottleRules API asynchronously
func (client *Client) GetAutoThrottleRulesWithCallback(request *GetAutoThrottleRulesRequest, callback func(response *GetAutoThrottleRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAutoThrottleRulesResponse
		var err error
		defer close(result)
		response, err = client.GetAutoThrottleRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAutoThrottleRulesRequest is the request struct for api GetAutoThrottleRules
type GetAutoThrottleRulesRequest struct {
	*requests.RpcRequest
	ConsoleContext string `position:"Query" name:"ConsoleContext"`
	InstanceIds    string `position:"Query" name:"InstanceIds"`
}

// GetAutoThrottleRulesResponse is the response struct for api GetAutoThrottleRules
type GetAutoThrottleRulesResponse struct {
	*responses.BaseResponse
	Code      int64  `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetAutoThrottleRulesRequest creates a request to invoke GetAutoThrottleRules API
func CreateGetAutoThrottleRulesRequest() (request *GetAutoThrottleRulesRequest) {
	request = &GetAutoThrottleRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "GetAutoThrottleRules", "", "")
	request.Method = requests.POST
	return
}

// CreateGetAutoThrottleRulesResponse creates a response to parse from GetAutoThrottleRules response
func CreateGetAutoThrottleRulesResponse() (response *GetAutoThrottleRulesResponse) {
	response = &GetAutoThrottleRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
