package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateBootAndAntiUninstallPolicy invokes the csas.UpdateBootAndAntiUninstallPolicy API synchronously
func (client *Client) UpdateBootAndAntiUninstallPolicy(request *UpdateBootAndAntiUninstallPolicyRequest) (response *UpdateBootAndAntiUninstallPolicyResponse, err error) {
	response = CreateUpdateBootAndAntiUninstallPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateBootAndAntiUninstallPolicyWithChan invokes the csas.UpdateBootAndAntiUninstallPolicy API asynchronously
func (client *Client) UpdateBootAndAntiUninstallPolicyWithChan(request *UpdateBootAndAntiUninstallPolicyRequest) (<-chan *UpdateBootAndAntiUninstallPolicyResponse, <-chan error) {
	responseChan := make(chan *UpdateBootAndAntiUninstallPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateBootAndAntiUninstallPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateBootAndAntiUninstallPolicyWithCallback invokes the csas.UpdateBootAndAntiUninstallPolicy API asynchronously
func (client *Client) UpdateBootAndAntiUninstallPolicyWithCallback(request *UpdateBootAndAntiUninstallPolicyRequest, callback func(response *UpdateBootAndAntiUninstallPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateBootAndAntiUninstallPolicyResponse
		var err error
		defer close(result)
		response, err = client.UpdateBootAndAntiUninstallPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateBootAndAntiUninstallPolicyRequest is the request struct for api UpdateBootAndAntiUninstallPolicy
type UpdateBootAndAntiUninstallPolicyRequest struct {
	*requests.RpcRequest
	IsAntiUninstall requests.Boolean                             `position:"Body" name:"IsAntiUninstall"`
	AllowReport     requests.Boolean                             `position:"Body" name:"AllowReport"`
	SourceIp        string                                       `position:"Query" name:"SourceIp"`
	UserGroupIds    *[]string                                    `position:"Body" name:"UserGroupIds"  type:"Repeated"`
	WhitelistUsers  *[]string                                    `position:"Body" name:"WhitelistUsers"  type:"Repeated"`
	BlockContent    UpdateBootAndAntiUninstallPolicyBlockContent `position:"Body" name:"BlockContent"  type:"Struct"`
	IsBoot          requests.Boolean                             `position:"Body" name:"IsBoot"`
}

// UpdateBootAndAntiUninstallPolicyBlockContent is a repeated param struct in UpdateBootAndAntiUninstallPolicyRequest
type UpdateBootAndAntiUninstallPolicyBlockContent struct {
	BlockTextZh UpdateBootAndAntiUninstallPolicyBlockContentBlockTextZh `name:"BlockTextZh" type:"Struct"`
	BlockTextEn UpdateBootAndAntiUninstallPolicyBlockContentBlockTextEn `name:"BlockTextEn" type:"Struct"`
}

// UpdateBootAndAntiUninstallPolicyBlockContentBlockTextZh is a repeated param struct in UpdateBootAndAntiUninstallPolicyRequest
type UpdateBootAndAntiUninstallPolicyBlockContentBlockTextZh struct {
	MinorButtonText string `name:"MinorButtonText"`
	MainButtonText  string `name:"MainButtonText"`
	Title           string `name:"Title"`
	Content         string `name:"Content"`
}

// UpdateBootAndAntiUninstallPolicyBlockContentBlockTextEn is a repeated param struct in UpdateBootAndAntiUninstallPolicyRequest
type UpdateBootAndAntiUninstallPolicyBlockContentBlockTextEn struct {
	MinorButtonText string `name:"MinorButtonText"`
	MainButtonText  string `name:"MainButtonText"`
	Title           string `name:"Title"`
	Content         string `name:"Content"`
}

// UpdateBootAndAntiUninstallPolicyResponse is the response struct for api UpdateBootAndAntiUninstallPolicy
type UpdateBootAndAntiUninstallPolicyResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Strategy  Strategy `json:"Strategy" xml:"Strategy"`
}

// CreateUpdateBootAndAntiUninstallPolicyRequest creates a request to invoke UpdateBootAndAntiUninstallPolicy API
func CreateUpdateBootAndAntiUninstallPolicyRequest() (request *UpdateBootAndAntiUninstallPolicyRequest) {
	request = &UpdateBootAndAntiUninstallPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "UpdateBootAndAntiUninstallPolicy", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateBootAndAntiUninstallPolicyResponse creates a response to parse from UpdateBootAndAntiUninstallPolicy response
func CreateUpdateBootAndAntiUninstallPolicyResponse() (response *UpdateBootAndAntiUninstallPolicyResponse) {
	response = &UpdateBootAndAntiUninstallPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
