package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetApprovalSchema invokes the csas.GetApprovalSchema API synchronously
func (client *Client) GetApprovalSchema(request *GetApprovalSchemaRequest) (response *GetApprovalSchemaResponse, err error) {
	response = CreateGetApprovalSchemaResponse()
	err = client.DoAction(request, response)
	return
}

// GetApprovalSchemaWithChan invokes the csas.GetApprovalSchema API asynchronously
func (client *Client) GetApprovalSchemaWithChan(request *GetApprovalSchemaRequest) (<-chan *GetApprovalSchemaResponse, <-chan error) {
	responseChan := make(chan *GetApprovalSchemaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetApprovalSchema(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetApprovalSchemaWithCallback invokes the csas.GetApprovalSchema API asynchronously
func (client *Client) GetApprovalSchemaWithCallback(request *GetApprovalSchemaRequest, callback func(response *GetApprovalSchemaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetApprovalSchemaResponse
		var err error
		defer close(result)
		response, err = client.GetApprovalSchema(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetApprovalSchemaRequest is the request struct for api GetApprovalSchema
type GetApprovalSchemaRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	SchemaId string `position:"Query" name:"SchemaId"`
}

// GetApprovalSchemaResponse is the response struct for api GetApprovalSchema
type GetApprovalSchemaResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Schema    Schema `json:"Schema" xml:"Schema"`
}

// CreateGetApprovalSchemaRequest creates a request to invoke GetApprovalSchema API
func CreateGetApprovalSchemaRequest() (request *GetApprovalSchemaRequest) {
	request = &GetApprovalSchemaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "GetApprovalSchema", "", "")
	request.Method = requests.GET
	return
}

// CreateGetApprovalSchemaResponse creates a response to parse from GetApprovalSchema response
func CreateGetApprovalSchemaResponse() (response *GetApprovalSchemaResponse) {
	response = &GetApprovalSchemaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
