package computenest

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartServiceInstance invokes the computenest.StartServiceInstance API synchronously
func (client *Client) StartServiceInstance(request *StartServiceInstanceRequest) (response *StartServiceInstanceResponse, err error) {
	response = CreateStartServiceInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// StartServiceInstanceWithChan invokes the computenest.StartServiceInstance API asynchronously
func (client *Client) StartServiceInstanceWithChan(request *StartServiceInstanceRequest) (<-chan *StartServiceInstanceResponse, <-chan error) {
	responseChan := make(chan *StartServiceInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartServiceInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartServiceInstanceWithCallback invokes the computenest.StartServiceInstance API asynchronously
func (client *Client) StartServiceInstanceWithCallback(request *StartServiceInstanceRequest, callback func(response *StartServiceInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartServiceInstanceResponse
		var err error
		defer close(result)
		response, err = client.StartServiceInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartServiceInstanceRequest is the request struct for api StartServiceInstance
type StartServiceInstanceRequest struct {
	*requests.RpcRequest
	ClientToken       string `position:"Query" name:"ClientToken"`
	ServiceInstanceId string `position:"Query" name:"ServiceInstanceId"`
}

// StartServiceInstanceResponse is the response struct for api StartServiceInstance
type StartServiceInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStartServiceInstanceRequest creates a request to invoke StartServiceInstance API
func CreateStartServiceInstanceRequest() (request *StartServiceInstanceRequest) {
	request = &StartServiceInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ComputeNest", "2021-06-01", "StartServiceInstance", "computenest", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStartServiceInstanceResponse creates a response to parse from StartServiceInstance response
func CreateStartServiceInstanceResponse() (response *StartServiceInstanceResponse) {
	response = &StartServiceInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
