package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOrganizationSecurityCenterStatus invokes the codeup.GetOrganizationSecurityCenterStatus API synchronously
func (client *Client) GetOrganizationSecurityCenterStatus(request *GetOrganizationSecurityCenterStatusRequest) (response *GetOrganizationSecurityCenterStatusResponse, err error) {
	response = CreateGetOrganizationSecurityCenterStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetOrganizationSecurityCenterStatusWithChan invokes the codeup.GetOrganizationSecurityCenterStatus API asynchronously
func (client *Client) GetOrganizationSecurityCenterStatusWithChan(request *GetOrganizationSecurityCenterStatusRequest) (<-chan *GetOrganizationSecurityCenterStatusResponse, <-chan error) {
	responseChan := make(chan *GetOrganizationSecurityCenterStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOrganizationSecurityCenterStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOrganizationSecurityCenterStatusWithCallback invokes the codeup.GetOrganizationSecurityCenterStatus API asynchronously
func (client *Client) GetOrganizationSecurityCenterStatusWithCallback(request *GetOrganizationSecurityCenterStatusRequest, callback func(response *GetOrganizationSecurityCenterStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOrganizationSecurityCenterStatusResponse
		var err error
		defer close(result)
		response, err = client.GetOrganizationSecurityCenterStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOrganizationSecurityCenterStatusRequest is the request struct for api GetOrganizationSecurityCenterStatus
type GetOrganizationSecurityCenterStatusRequest struct {
	*requests.RoaRequest
	AccessToken string `position:"Query" name:"AccessToken"`
}

// GetOrganizationSecurityCenterStatusResponse is the response struct for api GetOrganizationSecurityCenterStatus
type GetOrganizationSecurityCenterStatusResponse struct {
	*responses.BaseResponse
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Result       Result `json:"Result" xml:"Result"`
}

// CreateGetOrganizationSecurityCenterStatusRequest creates a request to invoke GetOrganizationSecurityCenterStatus API
func CreateGetOrganizationSecurityCenterStatusRequest() (request *GetOrganizationSecurityCenterStatusRequest) {
	request = &GetOrganizationSecurityCenterStatusRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "GetOrganizationSecurityCenterStatus", "/api/v4/organization/security/status", "", "")
	request.Method = requests.GET
	return
}

// CreateGetOrganizationSecurityCenterStatusResponse creates a response to parse from GetOrganizationSecurityCenterStatus response
func CreateGetOrganizationSecurityCenterStatusResponse() (response *GetOrganizationSecurityCenterStatusResponse) {
	response = &GetOrganizationSecurityCenterStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
