package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCodeCompletion invokes the codeup.GetCodeCompletion API synchronously
func (client *Client) GetCodeCompletion(request *GetCodeCompletionRequest) (response *GetCodeCompletionResponse, err error) {
	response = CreateGetCodeCompletionResponse()
	err = client.DoAction(request, response)
	return
}

// GetCodeCompletionWithChan invokes the codeup.GetCodeCompletion API asynchronously
func (client *Client) GetCodeCompletionWithChan(request *GetCodeCompletionRequest) (<-chan *GetCodeCompletionResponse, <-chan error) {
	responseChan := make(chan *GetCodeCompletionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCodeCompletion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCodeCompletionWithCallback invokes the codeup.GetCodeCompletion API asynchronously
func (client *Client) GetCodeCompletionWithCallback(request *GetCodeCompletionRequest, callback func(response *GetCodeCompletionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCodeCompletionResponse
		var err error
		defer close(result)
		response, err = client.GetCodeCompletion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCodeCompletionRequest is the request struct for api GetCodeCompletion
type GetCodeCompletionRequest struct {
	*requests.RoaRequest
	IsEncrypted requests.Boolean `position:"Query" name:"IsEncrypted"`
	FetchKeys   string           `position:"Query" name:"FetchKeys"`
	ServiceName string           `position:"Path" name:"ServiceName"`
}

// GetCodeCompletionResponse is the response struct for api GetCodeCompletion
type GetCodeCompletionResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Result       Result `json:"Result" xml:"Result"`
}

// CreateGetCodeCompletionRequest creates a request to invoke GetCodeCompletion API
func CreateGetCodeCompletionRequest() (request *GetCodeCompletionRequest) {
	request = &GetCodeCompletionRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "GetCodeCompletion", "/api/v2/service/invoke/[ServiceName]", "", "")
	request.Method = requests.POST
	return
}

// CreateGetCodeCompletionResponse creates a response to parse from GetCodeCompletion response
func CreateGetCodeCompletionResponse() (response *GetCodeCompletionResponse) {
	response = &GetCodeCompletionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
