package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConfigAutoRenew invokes the cloudwf.ConfigAutoRenew API synchronously
// api document: https://help.aliyun.com/api/cloudwf/configautorenew.html
func (client *Client) ConfigAutoRenew(request *ConfigAutoRenewRequest) (response *ConfigAutoRenewResponse, err error) {
	response = CreateConfigAutoRenewResponse()
	err = client.DoAction(request, response)
	return
}

// ConfigAutoRenewWithChan invokes the cloudwf.ConfigAutoRenew API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/configautorenew.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ConfigAutoRenewWithChan(request *ConfigAutoRenewRequest) (<-chan *ConfigAutoRenewResponse, <-chan error) {
	responseChan := make(chan *ConfigAutoRenewResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConfigAutoRenew(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConfigAutoRenewWithCallback invokes the cloudwf.ConfigAutoRenew API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/configautorenew.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ConfigAutoRenewWithCallback(request *ConfigAutoRenewRequest, callback func(response *ConfigAutoRenewResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConfigAutoRenewResponse
		var err error
		defer close(result)
		response, err = client.ConfigAutoRenew(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConfigAutoRenewRequest is the request struct for api ConfigAutoRenew
type ConfigAutoRenewRequest struct {
	*requests.RpcRequest
	OffsetDays requests.Integer `position:"Query" name:"OffsetDays"`
	Months     requests.Integer `position:"Query" name:"Months"`
	AutoRenew  requests.Boolean `position:"Query" name:"AutoRenew"`
	ApList     *[]string        `position:"Query" name:"ApList"  type:"Repeated"`
}

// ConfigAutoRenewResponse is the response struct for api ConfigAutoRenew
type ConfigAutoRenewResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"success" xml:"success"`
	Message   string `json:"message" xml:"message"`
	Code      string `json:"code" xml:"code"`
	Data      string `json:"data" xml:"data"`
}

// CreateConfigAutoRenewRequest creates a request to invoke ConfigAutoRenew API
func CreateConfigAutoRenewRequest() (request *ConfigAutoRenewRequest) {
	request = &ConfigAutoRenewRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ConfigAutoRenew", "cloudwf", "openAPI")
	return
}

// CreateConfigAutoRenewResponse creates a response to parse from ConfigAutoRenew response
func CreateConfigAutoRenewResponse() (response *ConfigAutoRenewResponse) {
	response = &ConfigAutoRenewResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
